// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The properties of an enrollment. </summary>
    public partial class BillingAccountEnrollmentDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingAccountEnrollmentDetails"/>. </summary>
        public BillingAccountEnrollmentDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingAccountEnrollmentDetails"/>. </summary>
        /// <param name="startOn"> The start date of the enrollment. </param>
        /// <param name="endOn"> The end date of the enrollment. </param>
        /// <param name="currency"> The billing currency for the enrollment. </param>
        /// <param name="channel"> The channel type of the enrollment. </param>
        /// <param name="language"> The language for the enrollment. </param>
        /// <param name="countryCode"> The country code of the enrollment. </param>
        /// <param name="billingCycle"> The billing cycle for the enrollment. </param>
        /// <param name="extendedTermOption"> The billing account extension opted by the company. </param>
        /// <param name="supportLevel"> The support level offer associated with an enrollment. </param>
        /// <param name="supportCoverage"> The support coverage period for the enrollment. </param>
        /// <param name="cloud"> The cloud of the enrollment. </param>
        /// <param name="poNumber"> The purchase order number of the enrollment. </param>
        /// <param name="markupStatus"> Markup status of enrollment, applicable only for indirect enrollments. </param>
        /// <param name="indirectRelationshipInfo"> The properties of an enrollment which are applicable only for indirect enrollments. </param>
        /// <param name="invoiceRecipient"> The contact who receives invoices of the enrollment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingAccountEnrollmentDetails(DateTimeOffset? startOn, DateTimeOffset? endOn, string currency, string channel, string language, string countryCode, string billingCycle, ExtendedTermOption? extendedTermOption, BillingEnrollmentSupportLevel? supportLevel, string supportCoverage, string cloud, string poNumber, EnrollmentMarkupStatus? markupStatus, IndirectRelationshipInfo indirectRelationshipInfo, string invoiceRecipient, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartOn = startOn;
            EndOn = endOn;
            Currency = currency;
            Channel = channel;
            Language = language;
            CountryCode = countryCode;
            BillingCycle = billingCycle;
            ExtendedTermOption = extendedTermOption;
            SupportLevel = supportLevel;
            SupportCoverage = supportCoverage;
            Cloud = cloud;
            PoNumber = poNumber;
            MarkupStatus = markupStatus;
            IndirectRelationshipInfo = indirectRelationshipInfo;
            InvoiceRecipient = invoiceRecipient;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The start date of the enrollment. </summary>
        [WirePath("startDate")]
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> The end date of the enrollment. </summary>
        [WirePath("endDate")]
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> The billing currency for the enrollment. </summary>
        [WirePath("currency")]
        public string Currency { get; }
        /// <summary> The channel type of the enrollment. </summary>
        [WirePath("channel")]
        public string Channel { get; }
        /// <summary> The language for the enrollment. </summary>
        [WirePath("language")]
        public string Language { get; }
        /// <summary> The country code of the enrollment. </summary>
        [WirePath("countryCode")]
        public string CountryCode { get; }
        /// <summary> The billing cycle for the enrollment. </summary>
        [WirePath("billingCycle")]
        public string BillingCycle { get; }
        /// <summary> The billing account extension opted by the company. </summary>
        [WirePath("extendedTermOption")]
        public ExtendedTermOption? ExtendedTermOption { get; }
        /// <summary> The support level offer associated with an enrollment. </summary>
        [WirePath("supportLevel")]
        public BillingEnrollmentSupportLevel? SupportLevel { get; }
        /// <summary> The support coverage period for the enrollment. </summary>
        [WirePath("supportCoverage")]
        public string SupportCoverage { get; }
        /// <summary> The cloud of the enrollment. </summary>
        [WirePath("cloud")]
        public string Cloud { get; }
        /// <summary> The purchase order number of the enrollment. </summary>
        [WirePath("poNumber")]
        public string PoNumber { get; set; }
        /// <summary> Markup status of enrollment, applicable only for indirect enrollments. </summary>
        [WirePath("markupStatus")]
        public EnrollmentMarkupStatus? MarkupStatus { get; }
        /// <summary> The properties of an enrollment which are applicable only for indirect enrollments. </summary>
        [WirePath("indirectRelationshipInfo")]
        public IndirectRelationshipInfo IndirectRelationshipInfo { get; set; }
        /// <summary> The contact who receives invoices of the enrollment. </summary>
        [WirePath("invoiceRecipient")]
        public string InvoiceRecipient { get; }
    }
}
