// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The BillingAccountCollectionGetAllOptions. </summary>
    public partial class BillingAccountCollectionGetAllOptions
    {
        /// <summary> Initializes a new instance of <see cref="BillingAccountCollectionGetAllOptions"/>. </summary>
        public BillingAccountCollectionGetAllOptions()
        {
        }

        /// <summary> When true, results will include Billing Accounts that the user does not have a direct role assignment on if the user has one of the following AAD roles: Global Administrator, Global Reader, Billing Administrator. </summary>
        [WirePath("includeAll")]
        public bool? IncludeAll { get; set; }
        /// <summary> When true, results will include Billing Accounts that are not fully created if the user has one of the following AAD roles: Global Administrator, Global Reader, Billing Administrator. </summary>
        [WirePath("includeAllWithoutBillingProfiles")]
        public bool? IncludeAllWithoutBillingProfiles { get; set; }
        /// <summary> When true, results will include any billing accounts in a deleted state. </summary>
        [WirePath("includeDeleted")]
        public bool? IncludeDeleted { get; set; }
        /// <summary> Includes billing accounts with agreement pending signature that the user has access to. </summary>
        [WirePath("includePendingAgreement")]
        public bool? IncludePendingAgreement { get; set; }
        /// <summary> Includes the customer's billing account of Microsoft Partner Agreement that the user has access to. </summary>
        [WirePath("includeResellee")]
        public bool? IncludeResellee { get; set; }
        /// <summary> Must be combined with legalOwnerOID, results will only include Billing Accounts for whom is legally responsible for the Billing Accounts. Optional. </summary>
        [WirePath("legalOwnerTID")]
        public string LegalOwnerTID { get; set; }
        /// <summary> Must be combined with legalOwnerTID, results will only include Billing Accounts for whom is legally responsible for the Billing Accounts. Optional. </summary>
        [WirePath("legalOwnerOID")]
        public string LegalOwnerOID { get; set; }
        /// <summary> The filter query option allows clients to filter a collection of resources that are addressed by a request URL. </summary>
        [WirePath("filter")]
        public string Filter { get; set; }
        /// <summary> Expand is allowed for SoldTo and EnrollmentDetails/PONumber. </summary>
        [WirePath("expand")]
        public string Expand { get; set; }
        /// <summary> The top query option requests the number of items in the queried collection to be included in the result. The maximum supported value for top is 50. </summary>
        [WirePath("top")]
        public long? Top { get; set; }
        /// <summary> The skip query option requests the number of items in the queried collection that are to be skipped and not included in the result. </summary>
        [WirePath("skip")]
        public long? Skip { get; set; }
        /// <summary> The search query option allows clients to request items within a collection matching a free-text search expression. search is only supported for string fields. </summary>
        [WirePath("search")]
        public string Search { get; set; }
    }
}
