// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingSubscriptionAliasOperationSource : IOperationSource<BillingSubscriptionAliasResource>
    {
        private readonly ArmClient _client;

        internal BillingSubscriptionAliasOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingSubscriptionAliasResource IOperationSource<BillingSubscriptionAliasResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingSubscriptionAliasData.DeserializeBillingSubscriptionAliasData(document.RootElement);
            return new BillingSubscriptionAliasResource(_client, data);
        }

        async ValueTask<BillingSubscriptionAliasResource> IOperationSource<BillingSubscriptionAliasResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingSubscriptionAliasData.DeserializeBillingSubscriptionAliasData(document.RootElement);
            return new BillingSubscriptionAliasResource(_client, data);
        }
    }
}
