// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingSavingsPlanModelOperationSource : IOperationSource<BillingSavingsPlanModelResource>
    {
        private readonly ArmClient _client;

        internal BillingSavingsPlanModelOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingSavingsPlanModelResource IOperationSource<BillingSavingsPlanModelResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingSavingsPlanModelData.DeserializeBillingSavingsPlanModelData(document.RootElement);
            return new BillingSavingsPlanModelResource(_client, data);
        }

        async ValueTask<BillingSavingsPlanModelResource> IOperationSource<BillingSavingsPlanModelResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingSavingsPlanModelData.DeserializeBillingSavingsPlanModelData(document.RootElement);
            return new BillingSavingsPlanModelResource(_client, data);
        }
    }
}
