// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingRoleAssignmentOperationSource : IOperationSource<BillingRoleAssignmentResource>
    {
        private readonly ArmClient _client;

        internal BillingRoleAssignmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingRoleAssignmentResource IOperationSource<BillingRoleAssignmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingRoleAssignmentData.DeserializeBillingRoleAssignmentData(document.RootElement);
            return new BillingRoleAssignmentResource(_client, data);
        }

        async ValueTask<BillingRoleAssignmentResource> IOperationSource<BillingRoleAssignmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingRoleAssignmentData.DeserializeBillingRoleAssignmentData(document.RootElement);
            return new BillingRoleAssignmentResource(_client, data);
        }
    }
}
