// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingReservationOperationSource : IOperationSource<BillingReservationResource>
    {
        private readonly ArmClient _client;

        internal BillingReservationOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingReservationResource IOperationSource<BillingReservationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingReservationData.DeserializeBillingReservationData(document.RootElement);
            return new BillingReservationResource(_client, data);
        }

        async ValueTask<BillingReservationResource> IOperationSource<BillingReservationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingReservationData.DeserializeBillingReservationData(document.RootElement);
            return new BillingReservationResource(_client, data);
        }
    }
}
