// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingRequestOperationSource : IOperationSource<BillingRequestResource>
    {
        private readonly ArmClient _client;

        internal BillingRequestOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingRequestResource IOperationSource<BillingRequestResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingRequestData.DeserializeBillingRequestData(document.RootElement);
            return new BillingRequestResource(_client, data);
        }

        async ValueTask<BillingRequestResource> IOperationSource<BillingRequestResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingRequestData.DeserializeBillingRequestData(document.RootElement);
            return new BillingRequestResource(_client, data);
        }
    }
}
