// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingProfilePolicyOperationSource : IOperationSource<BillingProfilePolicyResource>
    {
        private readonly ArmClient _client;

        internal BillingProfilePolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingProfilePolicyResource IOperationSource<BillingProfilePolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingProfilePolicyData.DeserializeBillingProfilePolicyData(document.RootElement);
            return new BillingProfilePolicyResource(_client, data);
        }

        async ValueTask<BillingProfilePolicyResource> IOperationSource<BillingProfilePolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingProfilePolicyData.DeserializeBillingProfilePolicyData(document.RootElement);
            return new BillingProfilePolicyResource(_client, data);
        }
    }
}
