// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingProfileOperationSource : IOperationSource<BillingProfileResource>
    {
        private readonly ArmClient _client;

        internal BillingProfileOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingProfileResource IOperationSource<BillingProfileResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingProfileData.DeserializeBillingProfileData(document.RootElement);
            return new BillingProfileResource(_client, data);
        }

        async ValueTask<BillingProfileResource> IOperationSource<BillingProfileResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingProfileData.DeserializeBillingProfileData(document.RootElement);
            return new BillingProfileResource(_client, data);
        }
    }
}
