// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingProductOperationSource : IOperationSource<BillingProductResource>
    {
        private readonly ArmClient _client;

        internal BillingProductOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingProductResource IOperationSource<BillingProductResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingProductData.DeserializeBillingProductData(document.RootElement);
            return new BillingProductResource(_client, data);
        }

        async ValueTask<BillingProductResource> IOperationSource<BillingProductResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingProductData.DeserializeBillingProductData(document.RootElement);
            return new BillingProductResource(_client, data);
        }
    }
}
