// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingInvoiceSectionOperationSource : IOperationSource<BillingInvoiceSectionResource>
    {
        private readonly ArmClient _client;

        internal BillingInvoiceSectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingInvoiceSectionResource IOperationSource<BillingInvoiceSectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingInvoiceSectionData.DeserializeBillingInvoiceSectionData(document.RootElement);
            return new BillingInvoiceSectionResource(_client, data);
        }

        async ValueTask<BillingInvoiceSectionResource> IOperationSource<BillingInvoiceSectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingInvoiceSectionData.DeserializeBillingInvoiceSectionData(document.RootElement);
            return new BillingInvoiceSectionResource(_client, data);
        }
    }
}
