// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingEnrollmentAccountRoleAssignmentOperationSource : IOperationSource<BillingEnrollmentAccountRoleAssignmentResource>
    {
        private readonly ArmClient _client;

        internal BillingEnrollmentAccountRoleAssignmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingEnrollmentAccountRoleAssignmentResource IOperationSource<BillingEnrollmentAccountRoleAssignmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingRoleAssignmentData.DeserializeBillingRoleAssignmentData(document.RootElement);
            return new BillingEnrollmentAccountRoleAssignmentResource(_client, data);
        }

        async ValueTask<BillingEnrollmentAccountRoleAssignmentResource> IOperationSource<BillingEnrollmentAccountRoleAssignmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingRoleAssignmentData.DeserializeBillingRoleAssignmentData(document.RootElement);
            return new BillingEnrollmentAccountRoleAssignmentResource(_client, data);
        }
    }
}
