// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingDepartmentRoleAssignmentOperationSource : IOperationSource<BillingDepartmentRoleAssignmentResource>
    {
        private readonly ArmClient _client;

        internal BillingDepartmentRoleAssignmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingDepartmentRoleAssignmentResource IOperationSource<BillingDepartmentRoleAssignmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingRoleAssignmentData.DeserializeBillingRoleAssignmentData(document.RootElement);
            return new BillingDepartmentRoleAssignmentResource(_client, data);
        }

        async ValueTask<BillingDepartmentRoleAssignmentResource> IOperationSource<BillingDepartmentRoleAssignmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingRoleAssignmentData.DeserializeBillingRoleAssignmentData(document.RootElement);
            return new BillingDepartmentRoleAssignmentResource(_client, data);
        }
    }
}
