// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingCustomerPolicyOperationSource : IOperationSource<BillingCustomerPolicyResource>
    {
        private readonly ArmClient _client;

        internal BillingCustomerPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingCustomerPolicyResource IOperationSource<BillingCustomerPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingCustomerPolicyData.DeserializeBillingCustomerPolicyData(document.RootElement);
            return new BillingCustomerPolicyResource(_client, data);
        }

        async ValueTask<BillingCustomerPolicyResource> IOperationSource<BillingCustomerPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingCustomerPolicyData.DeserializeBillingCustomerPolicyData(document.RootElement);
            return new BillingCustomerPolicyResource(_client, data);
        }
    }
}
