// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingAssociatedTenantOperationSource : IOperationSource<BillingAssociatedTenantResource>
    {
        private readonly ArmClient _client;

        internal BillingAssociatedTenantOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingAssociatedTenantResource IOperationSource<BillingAssociatedTenantResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingAssociatedTenantData.DeserializeBillingAssociatedTenantData(document.RootElement);
            return new BillingAssociatedTenantResource(_client, data);
        }

        async ValueTask<BillingAssociatedTenantResource> IOperationSource<BillingAssociatedTenantResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingAssociatedTenantData.DeserializeBillingAssociatedTenantData(document.RootElement);
            return new BillingAssociatedTenantResource(_client, data);
        }
    }
}
