// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Billing
{
    internal class BillingAccountPolicyOperationSource : IOperationSource<BillingAccountPolicyResource>
    {
        private readonly ArmClient _client;

        internal BillingAccountPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingAccountPolicyResource IOperationSource<BillingAccountPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingAccountPolicyData.DeserializeBillingAccountPolicyData(document.RootElement);
            return new BillingAccountPolicyResource(_client, data);
        }

        async ValueTask<BillingAccountPolicyResource> IOperationSource<BillingAccountPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingAccountPolicyData.DeserializeBillingAccountPolicyData(document.RootElement);
            return new BillingAccountPolicyResource(_client, data);
        }
    }
}
