// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Billing.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableBillingSubscriptionResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableBillingSubscriptionResource"/> class for mocking. </summary>
        protected MockableBillingSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableBillingSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableBillingSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets an object representing a BillingPropertyResource along with the instance operations that can be performed on it in the SubscriptionResource. </summary>
        /// <returns> Returns a <see cref="BillingPropertyResource"/> object. </returns>
        public virtual BillingPropertyResource GetBillingProperty()
        {
            return new BillingPropertyResource(Client, Id.AppendProviderResource("Microsoft.Billing", "billingProperty", "default"));
        }

        /// <summary> Gets an object representing a SubscriptionPolicyResource along with the instance operations that can be performed on it in the SubscriptionResource. </summary>
        /// <returns> Returns a <see cref="SubscriptionPolicyResource"/> object. </returns>
        public virtual SubscriptionPolicyResource GetSubscriptionPolicy()
        {
            return new SubscriptionPolicyResource(Client, Id.AppendProviderResource("Microsoft.Billing", "policies", "default"));
        }
    }
}
