// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="DefaultBillingInvoiceResource"/> and their operations.
    /// Each <see cref="DefaultBillingInvoiceResource"/> in the collection will belong to the same instance of <see cref="TenantResource"/>.
    /// To get a <see cref="DefaultBillingInvoiceCollection"/> instance call the GetDefaultBillingInvoices method from an instance of <see cref="TenantResource"/>.
    /// </summary>
    public partial class DefaultBillingInvoiceCollection : ArmCollection
    {
        private readonly ClientDiagnostics _defaultBillingInvoiceInvoicesClientDiagnostics;
        private readonly InvoicesRestOperations _defaultBillingInvoiceInvoicesRestClient;

        /// <summary> Initializes a new instance of the <see cref="DefaultBillingInvoiceCollection"/> class for mocking. </summary>
        protected DefaultBillingInvoiceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DefaultBillingInvoiceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DefaultBillingInvoiceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _defaultBillingInvoiceInvoicesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", DefaultBillingInvoiceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DefaultBillingInvoiceResource.ResourceType, out string defaultBillingInvoiceInvoicesApiVersion);
            _defaultBillingInvoiceInvoicesRestClient = new InvoicesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, defaultBillingInvoiceInvoicesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != TenantResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, TenantResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an invoice by ID. The operation is supported for billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DefaultBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual async Task<Response<DefaultBillingInvoiceResource>> GetAsync(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _defaultBillingInvoiceInvoicesClientDiagnostics.CreateScope("DefaultBillingInvoiceCollection.Get");
            scope.Start();
            try
            {
                var response = await _defaultBillingInvoiceInvoicesRestClient.GetAsync(invoiceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DefaultBillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an invoice by ID. The operation is supported for billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DefaultBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual Response<DefaultBillingInvoiceResource> Get(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _defaultBillingInvoiceInvoicesClientDiagnostics.CreateScope("DefaultBillingInvoiceCollection.Get");
            scope.Start();
            try
            {
                var response = _defaultBillingInvoiceInvoicesRestClient.Get(invoiceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DefaultBillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DefaultBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _defaultBillingInvoiceInvoicesClientDiagnostics.CreateScope("DefaultBillingInvoiceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _defaultBillingInvoiceInvoicesRestClient.GetAsync(invoiceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DefaultBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual Response<bool> Exists(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _defaultBillingInvoiceInvoicesClientDiagnostics.CreateScope("DefaultBillingInvoiceCollection.Exists");
            scope.Start();
            try
            {
                var response = _defaultBillingInvoiceInvoicesRestClient.Get(invoiceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DefaultBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual async Task<NullableResponse<DefaultBillingInvoiceResource>> GetIfExistsAsync(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _defaultBillingInvoiceInvoicesClientDiagnostics.CreateScope("DefaultBillingInvoiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _defaultBillingInvoiceInvoicesRestClient.GetAsync(invoiceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DefaultBillingInvoiceResource>(response.GetRawResponse());
                return Response.FromValue(new DefaultBillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DefaultBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual NullableResponse<DefaultBillingInvoiceResource> GetIfExists(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _defaultBillingInvoiceInvoicesClientDiagnostics.CreateScope("DefaultBillingInvoiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _defaultBillingInvoiceInvoicesRestClient.Get(invoiceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DefaultBillingInvoiceResource>(response.GetRawResponse());
                return Response.FromValue(new DefaultBillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
