// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingTransferDetailResource"/> and their operations.
    /// Each <see cref="BillingTransferDetailResource"/> in the collection will belong to the same instance of <see cref="BillingInvoiceSectionResource"/>.
    /// To get a <see cref="BillingTransferDetailCollection"/> instance call the GetBillingTransferDetails method from an instance of <see cref="BillingInvoiceSectionResource"/>.
    /// </summary>
    public partial class BillingTransferDetailCollection : ArmCollection, IEnumerable<BillingTransferDetailResource>, IAsyncEnumerable<BillingTransferDetailResource>
    {
        private readonly ClientDiagnostics _billingTransferDetailTransfersClientDiagnostics;
        private readonly TransfersRestOperations _billingTransferDetailTransfersRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingTransferDetailCollection"/> class for mocking. </summary>
        protected BillingTransferDetailCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingTransferDetailCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingTransferDetailCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingTransferDetailTransfersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingTransferDetailResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingTransferDetailResource.ResourceType, out string billingTransferDetailTransfersApiVersion);
            _billingTransferDetailTransfersRestClient = new TransfersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingTransferDetailTransfersApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingInvoiceSectionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingInvoiceSectionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Sends a request to a user in another billing account to transfer billing ownership of their subscriptions. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transfers_Initiate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="content"> Request parameters that are provided to the initiate transfer operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> or <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<BillingTransferDetailResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string transferName, BillingTransferDetailCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _billingTransferDetailTransfersClientDiagnostics.CreateScope("BillingTransferDetailCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _billingTransferDetailTransfersRestClient.InitiateAsync(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, transferName, content, cancellationToken).ConfigureAwait(false);
                var uri = _billingTransferDetailTransfersRestClient.CreateInitiateRequestUri(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, transferName, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new BillingArmOperation<BillingTransferDetailResource>(Response.FromValue(new BillingTransferDetailResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Sends a request to a user in another billing account to transfer billing ownership of their subscriptions. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transfers_Initiate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="content"> Request parameters that are provided to the initiate transfer operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> or <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<BillingTransferDetailResource> CreateOrUpdate(WaitUntil waitUntil, string transferName, BillingTransferDetailCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _billingTransferDetailTransfersClientDiagnostics.CreateScope("BillingTransferDetailCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _billingTransferDetailTransfersRestClient.Initiate(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, transferName, content, cancellationToken);
                var uri = _billingTransferDetailTransfersRestClient.CreateInitiateRequestUri(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, transferName, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new BillingArmOperation<BillingTransferDetailResource>(Response.FromValue(new BillingTransferDetailResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a transfer request by ID. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual async Task<Response<BillingTransferDetailResource>> GetAsync(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _billingTransferDetailTransfersClientDiagnostics.CreateScope("BillingTransferDetailCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingTransferDetailTransfersRestClient.GetAsync(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, transferName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingTransferDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a transfer request by ID. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual Response<BillingTransferDetailResource> Get(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _billingTransferDetailTransfersClientDiagnostics.CreateScope("BillingTransferDetailCollection.Get");
            scope.Start();
            try
            {
                var response = _billingTransferDetailTransfersRestClient.Get(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, transferName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingTransferDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the transfer requests for an invoice section. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/transfers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transfers_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingTransferDetailResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingTransferDetailResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingTransferDetailTransfersRestClient.CreateListRequest(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingTransferDetailTransfersRestClient.CreateListNextPageRequest(nextLink, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingTransferDetailResource(Client, BillingTransferDetailData.DeserializeBillingTransferDetailData(e)), _billingTransferDetailTransfersClientDiagnostics, Pipeline, "BillingTransferDetailCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the transfer requests for an invoice section. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/transfers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transfers_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingTransferDetailResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingTransferDetailResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingTransferDetailTransfersRestClient.CreateListRequest(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingTransferDetailTransfersRestClient.CreateListNextPageRequest(nextLink, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingTransferDetailResource(Client, BillingTransferDetailData.DeserializeBillingTransferDetailData(e)), _billingTransferDetailTransfersClientDiagnostics, Pipeline, "BillingTransferDetailCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _billingTransferDetailTransfersClientDiagnostics.CreateScope("BillingTransferDetailCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingTransferDetailTransfersRestClient.GetAsync(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, transferName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual Response<bool> Exists(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _billingTransferDetailTransfersClientDiagnostics.CreateScope("BillingTransferDetailCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingTransferDetailTransfersRestClient.Get(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, transferName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingTransferDetailResource>> GetIfExistsAsync(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _billingTransferDetailTransfersClientDiagnostics.CreateScope("BillingTransferDetailCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingTransferDetailTransfersRestClient.GetAsync(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, transferName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingTransferDetailResource>(response.GetRawResponse());
                return Response.FromValue(new BillingTransferDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual NullableResponse<BillingTransferDetailResource> GetIfExists(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _billingTransferDetailTransfersClientDiagnostics.CreateScope("BillingTransferDetailCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingTransferDetailTransfersRestClient.Get(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, transferName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingTransferDetailResource>(response.GetRawResponse());
                return Response.FromValue(new BillingTransferDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingTransferDetailResource> IEnumerable<BillingTransferDetailResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<BillingTransferDetailResource> IAsyncEnumerable<BillingTransferDetailResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
