// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Billing.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Billing
{
    public partial class BillingSubscriptionAliasData : IUtf8JsonSerializable, IJsonModel<BillingSubscriptionAliasData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BillingSubscriptionAliasData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BillingSubscriptionAliasData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingSubscriptionAliasData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingSubscriptionAliasData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(AutoRenew))
            {
                writer.WritePropertyName("autoRenew"u8);
                writer.WriteStringValue(AutoRenew.Value.ToString());
            }
            if (Optional.IsDefined(SubscriptionAliasBeneficiaryTenantId))
            {
                writer.WritePropertyName("beneficiaryTenantId"u8);
                writer.WriteStringValue(SubscriptionAliasBeneficiaryTenantId.Value);
            }
            if (Optional.IsDefined(Beneficiary))
            {
                writer.WritePropertyName("beneficiary"u8);
                writer.WriteObjectValue(Beneficiary, options);
            }
            if (Optional.IsDefined(BillingFrequency))
            {
                writer.WritePropertyName("billingFrequency"u8);
                writer.WriteStringValue(BillingFrequency);
            }
            if (Optional.IsDefined(BillingProfileId))
            {
                writer.WritePropertyName("billingProfileId"u8);
                writer.WriteStringValue(BillingProfileId);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(BillingPolicies))
            {
                writer.WritePropertyName("billingPolicies"u8);
                writer.WriteStartObject();
                foreach (var item in BillingPolicies)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (options.Format != "W" && Optional.IsDefined(BillingProfileDisplayName))
            {
                writer.WritePropertyName("billingProfileDisplayName"u8);
                writer.WriteStringValue(BillingProfileDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingProfileName))
            {
                writer.WritePropertyName("billingProfileName"u8);
                writer.WriteStringValue(BillingProfileName);
            }
            if (Optional.IsDefined(ConsumptionCostCenter))
            {
                writer.WritePropertyName("consumptionCostCenter"u8);
                writer.WriteStringValue(ConsumptionCostCenter);
            }
            if (Optional.IsDefined(SubscriptionAliasCustomerId))
            {
                writer.WritePropertyName("customerId"u8);
                writer.WriteStringValue(SubscriptionAliasCustomerId);
            }
            if (options.Format != "W" && Optional.IsDefined(CustomerDisplayName))
            {
                writer.WritePropertyName("customerDisplayName"u8);
                writer.WriteStringValue(CustomerDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(CustomerName))
            {
                writer.WritePropertyName("customerName"u8);
                writer.WriteStringValue(CustomerName);
            }
            if (Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(EnrollmentAccountId))
            {
                writer.WritePropertyName("enrollmentAccountId"u8);
                writer.WriteStringValue(EnrollmentAccountId);
            }
            if (options.Format != "W" && Optional.IsDefined(EnrollmentAccountDisplayName))
            {
                writer.WritePropertyName("enrollmentAccountDisplayName"u8);
                writer.WriteStringValue(EnrollmentAccountDisplayName);
            }
            if (Optional.IsDefined(InvoiceSectionId))
            {
                writer.WritePropertyName("invoiceSectionId"u8);
                writer.WriteStringValue(InvoiceSectionId);
            }
            if (options.Format != "W" && Optional.IsDefined(InvoiceSectionDisplayName))
            {
                writer.WritePropertyName("invoiceSectionDisplayName"u8);
                writer.WriteStringValue(InvoiceSectionDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(InvoiceSectionName))
            {
                writer.WritePropertyName("invoiceSectionName"u8);
                writer.WriteStringValue(InvoiceSectionName);
            }
            if (options.Format != "W" && Optional.IsDefined(LastMonthCharges))
            {
                writer.WritePropertyName("lastMonthCharges"u8);
                writer.WriteObjectValue(LastMonthCharges, options);
            }
            if (options.Format != "W" && Optional.IsDefined(MonthToDateCharges))
            {
                writer.WritePropertyName("monthToDateCharges"u8);
                writer.WriteObjectValue(MonthToDateCharges, options);
            }
            if (options.Format != "W" && Optional.IsDefined(NextBillingCycleDetails))
            {
                writer.WritePropertyName("nextBillingCycleDetails"u8);
                writer.WriteObjectValue(NextBillingCycleDetails, options);
            }
            if (options.Format != "W" && Optional.IsDefined(OfferId))
            {
                writer.WritePropertyName("offerId"u8);
                writer.WriteStringValue(OfferId);
            }
            if (options.Format != "W" && Optional.IsDefined(ProductCategory))
            {
                writer.WritePropertyName("productCategory"u8);
                writer.WriteStringValue(ProductCategory);
            }
            if (options.Format != "W" && Optional.IsDefined(ProductType))
            {
                writer.WritePropertyName("productType"u8);
                writer.WriteStringValue(ProductType);
            }
            if (Optional.IsDefined(ProductTypeId))
            {
                writer.WritePropertyName("productTypeId"u8);
                writer.WriteStringValue(ProductTypeId);
            }
            if (options.Format != "W" && Optional.IsDefined(PurchaseOn))
            {
                writer.WritePropertyName("purchaseDate"u8);
                writer.WriteStringValue(PurchaseOn.Value, "O");
            }
            if (Optional.IsDefined(Quantity))
            {
                writer.WritePropertyName("quantity"u8);
                writer.WriteNumberValue(Quantity.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Reseller))
            {
                writer.WritePropertyName("reseller"u8);
                writer.WriteObjectValue(Reseller, options);
            }
            if (options.Format != "W" && Optional.IsDefined(RenewalTermDetails))
            {
                writer.WritePropertyName("renewalTermDetails"u8);
                writer.WriteObjectValue(RenewalTermDetails, options);
            }
            if (Optional.IsDefined(SkuId))
            {
                writer.WritePropertyName("skuId"u8);
                writer.WriteStringValue(SkuId);
            }
            if (options.Format != "W" && Optional.IsDefined(SkuDescription))
            {
                writer.WritePropertyName("skuDescription"u8);
                writer.WriteStringValue(SkuDescription);
            }
            if (Optional.IsDefined(SystemOverrides))
            {
                writer.WritePropertyName("systemOverrides"u8);
                writer.WriteObjectValue(SystemOverrides, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceUri))
            {
                writer.WritePropertyName("resourceUri"u8);
                writer.WriteStringValue(ResourceUri.AbsoluteUri);
            }
            if (Optional.IsDefined(TermDuration))
            {
                writer.WritePropertyName("termDuration"u8);
                writer.WriteStringValue(TermDuration.Value, "P");
            }
            if (options.Format != "W" && Optional.IsDefined(TermStartOn))
            {
                writer.WritePropertyName("termStartDate"u8);
                writer.WriteStringValue(TermStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(TermEndOn))
            {
                writer.WritePropertyName("termEndDate"u8);
                writer.WriteStringValue(TermEndOn.Value, "O");
            }
            if (Optional.IsDefined(ProvisioningTenantId))
            {
                writer.WritePropertyName("provisioningTenantId"u8);
                writer.WriteStringValue(ProvisioningTenantId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(OperationStatus))
            {
                writer.WritePropertyName("operationStatus"u8);
                writer.WriteStringValue(OperationStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(SubscriptionId))
            {
                writer.WritePropertyName("subscriptionId"u8);
                writer.WriteStringValue(SubscriptionId);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SuspensionReasons))
            {
                writer.WritePropertyName("suspensionReasons"u8);
                writer.WriteStartArray();
                foreach (var item in SuspensionReasons)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SuspensionReasonDetails))
            {
                writer.WritePropertyName("suspensionReasonDetails"u8);
                writer.WriteStartArray();
                foreach (var item in SuspensionReasonDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(SubscriptionAliasSubscriptionId))
            {
                writer.WritePropertyName("billingSubscriptionId"u8);
                writer.WriteStringValue(SubscriptionAliasSubscriptionId);
            }
            writer.WritePropertyName("enrollmentAccountSubscriptionDetails"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(EnrollmentAccountStartOn))
            {
                writer.WritePropertyName("enrollmentAccountStartDate"u8);
                writer.WriteStringValue(EnrollmentAccountStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(SubscriptionEnrollmentAccountStatus))
            {
                writer.WritePropertyName("subscriptionEnrollmentAccountStatus"u8);
                writer.WriteStringValue(SubscriptionEnrollmentAccountStatus.Value.ToString());
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
        }

        BillingSubscriptionAliasData IJsonModel<BillingSubscriptionAliasData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingSubscriptionAliasData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingSubscriptionAliasData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBillingSubscriptionAliasData(document.RootElement, options);
        }

        internal static BillingSubscriptionAliasData DeserializeBillingSubscriptionAliasData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            BillingSubscriptionAutoRenewState? autoRenew = default;
            Guid? beneficiaryTenantId = default;
            BillingBeneficiary beneficiary = default;
            string billingFrequency = default;
            ResourceIdentifier billingProfileId = default;
            IReadOnlyDictionary<string, string> billingPolicies = default;
            string billingProfileDisplayName = default;
            string billingProfileName = default;
            string consumptionCostCenter = default;
            string customerId = default;
            string customerDisplayName = default;
            string customerName = default;
            string displayName = default;
            string enrollmentAccountId = default;
            string enrollmentAccountDisplayName = default;
            ResourceIdentifier invoiceSectionId = default;
            string invoiceSectionDisplayName = default;
            string invoiceSectionName = default;
            BillingAmount lastMonthCharges = default;
            BillingAmount monthToDateCharges = default;
            NextBillingCycleDetails nextBillingCycleDetails = default;
            string offerId = default;
            string productCategory = default;
            string productType = default;
            string productTypeId = default;
            DateTimeOffset? purchaseDate = default;
            long? quantity = default;
            CreatedSubscriptionReseller reseller = default;
            SubscriptionRenewalTermDetails renewalTermDetails = default;
            string skuId = default;
            string skuDescription = default;
            BillingSystemOverrides systemOverrides = default;
            Uri resourceUri = default;
            TimeSpan? termDuration = default;
            DateTimeOffset? termStartDate = default;
            DateTimeOffset? termEndDate = default;
            Guid? provisioningTenantId = default;
            BillingSubscriptionStatus? status = default;
            BillingSubscriptionOperationStatus? operationStatus = default;
            BillingProvisioningState? provisioningState = default;
            string subscriptionId = default;
            IReadOnlyList<string> suspensionReasons = default;
            IReadOnlyList<BillingSubscriptionStatusDetails> suspensionReasonDetails = default;
            string billingSubscriptionId = default;
            DateTimeOffset? enrollmentAccountStartDate = default;
            SubscriptionEnrollmentAccountStatus? subscriptionEnrollmentAccountStatus = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("autoRenew"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoRenew = new BillingSubscriptionAutoRenewState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("beneficiaryTenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            beneficiaryTenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("beneficiary"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            beneficiary = BillingBeneficiary.DeserializeBillingBeneficiary(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("billingFrequency"u8))
                        {
                            billingFrequency = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("billingProfileId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            billingProfileId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("billingPolicies"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            billingPolicies = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("billingProfileDisplayName"u8))
                        {
                            billingProfileDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("billingProfileName"u8))
                        {
                            billingProfileName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("consumptionCostCenter"u8))
                        {
                            consumptionCostCenter = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("customerId"u8))
                        {
                            customerId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("customerDisplayName"u8))
                        {
                            customerDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("customerName"u8))
                        {
                            customerName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("displayName"u8))
                        {
                            displayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("enrollmentAccountId"u8))
                        {
                            enrollmentAccountId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("enrollmentAccountDisplayName"u8))
                        {
                            enrollmentAccountDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("invoiceSectionId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            invoiceSectionId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("invoiceSectionDisplayName"u8))
                        {
                            invoiceSectionDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("invoiceSectionName"u8))
                        {
                            invoiceSectionName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("lastMonthCharges"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastMonthCharges = BillingAmount.DeserializeBillingAmount(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("monthToDateCharges"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            monthToDateCharges = BillingAmount.DeserializeBillingAmount(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("nextBillingCycleDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            nextBillingCycleDetails = NextBillingCycleDetails.DeserializeNextBillingCycleDetails(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("offerId"u8))
                        {
                            offerId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("productCategory"u8))
                        {
                            productCategory = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("productType"u8))
                        {
                            productType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("productTypeId"u8))
                        {
                            productTypeId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("purchaseDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            purchaseDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("quantity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            quantity = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("reseller"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            reseller = CreatedSubscriptionReseller.DeserializeCreatedSubscriptionReseller(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("renewalTermDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            renewalTermDetails = SubscriptionRenewalTermDetails.DeserializeSubscriptionRenewalTermDetails(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("skuId"u8))
                        {
                            skuId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("skuDescription"u8))
                        {
                            skuDescription = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("systemOverrides"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            systemOverrides = BillingSystemOverrides.DeserializeBillingSystemOverrides(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("resourceUri"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("termDuration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            termDuration = property0.Value.GetTimeSpan("P");
                            continue;
                        }
                        if (property0.NameEquals("termStartDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            termStartDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("termEndDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            termEndDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("provisioningTenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningTenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("status"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            status = new BillingSubscriptionStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("operationStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            operationStatus = new BillingSubscriptionOperationStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new BillingProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("subscriptionId"u8))
                        {
                            subscriptionId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("suspensionReasons"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            suspensionReasons = array;
                            continue;
                        }
                        if (property0.NameEquals("suspensionReasonDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<BillingSubscriptionStatusDetails> array = new List<BillingSubscriptionStatusDetails>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(BillingSubscriptionStatusDetails.DeserializeBillingSubscriptionStatusDetails(item, options));
                            }
                            suspensionReasonDetails = array;
                            continue;
                        }
                        if (property0.NameEquals("billingSubscriptionId"u8))
                        {
                            billingSubscriptionId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("enrollmentAccountSubscriptionDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("enrollmentAccountStartDate"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    enrollmentAccountStartDate = property1.Value.GetDateTimeOffset("O");
                                    continue;
                                }
                                if (property1.NameEquals("subscriptionEnrollmentAccountStatus"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    subscriptionEnrollmentAccountStatus = new SubscriptionEnrollmentAccountStatus(property1.Value.GetString());
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BillingSubscriptionAliasData(
                id,
                name,
                type,
                systemData,
                autoRenew,
                beneficiaryTenantId,
                beneficiary,
                billingFrequency,
                billingProfileId,
                billingPolicies ?? new ChangeTrackingDictionary<string, string>(),
                billingProfileDisplayName,
                billingProfileName,
                consumptionCostCenter,
                customerId,
                customerDisplayName,
                customerName,
                displayName,
                enrollmentAccountId,
                enrollmentAccountDisplayName,
                invoiceSectionId,
                invoiceSectionDisplayName,
                invoiceSectionName,
                lastMonthCharges,
                monthToDateCharges,
                nextBillingCycleDetails,
                offerId,
                productCategory,
                productType,
                productTypeId,
                purchaseDate,
                quantity,
                reseller,
                renewalTermDetails,
                skuId,
                skuDescription,
                systemOverrides,
                resourceUri,
                termDuration,
                termStartDate,
                termEndDate,
                provisioningTenantId,
                status,
                operationStatus,
                provisioningState,
                subscriptionId,
                suspensionReasons ?? new ChangeTrackingList<string>(),
                suspensionReasonDetails ?? new ChangeTrackingList<BillingSubscriptionStatusDetails>(),
                enrollmentAccountStartDate,
                subscriptionEnrollmentAccountStatus,
                billingSubscriptionId,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AutoRenew), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    autoRenew: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AutoRenew))
                {
                    builder.Append("    autoRenew: ");
                    builder.AppendLine($"'{AutoRenew.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SubscriptionAliasBeneficiaryTenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    beneficiaryTenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SubscriptionAliasBeneficiaryTenantId))
                {
                    builder.Append("    beneficiaryTenantId: ");
                    builder.AppendLine($"'{SubscriptionAliasBeneficiaryTenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Beneficiary), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    beneficiary: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Beneficiary))
                {
                    builder.Append("    beneficiary: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Beneficiary, options, 4, false, "    beneficiary: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingFrequency), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    billingFrequency: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingFrequency))
                {
                    builder.Append("    billingFrequency: ");
                    if (BillingFrequency.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BillingFrequency}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BillingFrequency}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingProfileId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    billingProfileId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingProfileId))
                {
                    builder.Append("    billingProfileId: ");
                    builder.AppendLine($"'{BillingProfileId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingPolicies), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    billingPolicies: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(BillingPolicies))
                {
                    if (BillingPolicies.Any())
                    {
                        builder.Append("    billingPolicies: ");
                        builder.AppendLine("{");
                        foreach (var item in BillingPolicies)
                        {
                            builder.Append($"        '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingProfileDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    billingProfileDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingProfileDisplayName))
                {
                    builder.Append("    billingProfileDisplayName: ");
                    if (BillingProfileDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BillingProfileDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BillingProfileDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingProfileName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    billingProfileName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingProfileName))
                {
                    builder.Append("    billingProfileName: ");
                    if (BillingProfileName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BillingProfileName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BillingProfileName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConsumptionCostCenter), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    consumptionCostCenter: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConsumptionCostCenter))
                {
                    builder.Append("    consumptionCostCenter: ");
                    if (ConsumptionCostCenter.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ConsumptionCostCenter}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ConsumptionCostCenter}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SubscriptionAliasCustomerId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    customerId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SubscriptionAliasCustomerId))
                {
                    builder.Append("    customerId: ");
                    if (SubscriptionAliasCustomerId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SubscriptionAliasCustomerId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SubscriptionAliasCustomerId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomerDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    customerDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CustomerDisplayName))
                {
                    builder.Append("    customerDisplayName: ");
                    if (CustomerDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CustomerDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CustomerDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomerName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    customerName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CustomerName))
                {
                    builder.Append("    customerName: ");
                    if (CustomerName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CustomerName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CustomerName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    displayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisplayName))
                {
                    builder.Append("    displayName: ");
                    if (DisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnrollmentAccountId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enrollmentAccountId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnrollmentAccountId))
                {
                    builder.Append("    enrollmentAccountId: ");
                    if (EnrollmentAccountId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{EnrollmentAccountId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{EnrollmentAccountId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnrollmentAccountDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enrollmentAccountDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnrollmentAccountDisplayName))
                {
                    builder.Append("    enrollmentAccountDisplayName: ");
                    if (EnrollmentAccountDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{EnrollmentAccountDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{EnrollmentAccountDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoiceSectionId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    invoiceSectionId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoiceSectionId))
                {
                    builder.Append("    invoiceSectionId: ");
                    builder.AppendLine($"'{InvoiceSectionId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoiceSectionDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    invoiceSectionDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoiceSectionDisplayName))
                {
                    builder.Append("    invoiceSectionDisplayName: ");
                    if (InvoiceSectionDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{InvoiceSectionDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{InvoiceSectionDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoiceSectionName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    invoiceSectionName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoiceSectionName))
                {
                    builder.Append("    invoiceSectionName: ");
                    if (InvoiceSectionName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{InvoiceSectionName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{InvoiceSectionName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastMonthCharges), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastMonthCharges: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastMonthCharges))
                {
                    builder.Append("    lastMonthCharges: ");
                    BicepSerializationHelpers.AppendChildObject(builder, LastMonthCharges, options, 4, false, "    lastMonthCharges: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MonthToDateCharges), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    monthToDateCharges: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MonthToDateCharges))
                {
                    builder.Append("    monthToDateCharges: ");
                    BicepSerializationHelpers.AppendChildObject(builder, MonthToDateCharges, options, 4, false, "    monthToDateCharges: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("NextBillingCycleBillingFrequency", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    nextBillingCycleDetails: ");
                builder.AppendLine("{");
                builder.AppendLine("      nextBillingCycleDetails: {");
                builder.Append("        billingFrequency: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(NextBillingCycleDetails))
                {
                    builder.Append("    nextBillingCycleDetails: ");
                    BicepSerializationHelpers.AppendChildObject(builder, NextBillingCycleDetails, options, 4, false, "    nextBillingCycleDetails: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OfferId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    offerId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OfferId))
                {
                    builder.Append("    offerId: ");
                    if (OfferId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{OfferId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{OfferId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProductCategory), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    productCategory: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProductCategory))
                {
                    builder.Append("    productCategory: ");
                    if (ProductCategory.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProductCategory}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProductCategory}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProductType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    productType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProductType))
                {
                    builder.Append("    productType: ");
                    if (ProductType.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProductType}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProductType}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProductTypeId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    productTypeId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProductTypeId))
                {
                    builder.Append("    productTypeId: ");
                    if (ProductTypeId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProductTypeId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProductTypeId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PurchaseOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    purchaseDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PurchaseOn))
                {
                    builder.Append("    purchaseDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(PurchaseOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Quantity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    quantity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Quantity))
                {
                    builder.Append("    quantity: ");
                    builder.AppendLine($"'{Quantity.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Reseller), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    reseller: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Reseller))
                {
                    builder.Append("    reseller: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Reseller, options, 4, false, "    reseller: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RenewalTermDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    renewalTermDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RenewalTermDetails))
                {
                    builder.Append("    renewalTermDetails: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RenewalTermDetails, options, 4, false, "    renewalTermDetails: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SkuId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    skuId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SkuId))
                {
                    builder.Append("    skuId: ");
                    if (SkuId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SkuId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SkuId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SkuDescription), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    skuDescription: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SkuDescription))
                {
                    builder.Append("    skuDescription: ");
                    if (SkuDescription.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SkuDescription}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SkuDescription}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemOverrides), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    systemOverrides: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemOverrides))
                {
                    builder.Append("    systemOverrides: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SystemOverrides, options, 4, false, "    systemOverrides: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResourceUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    resourceUri: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ResourceUri))
                {
                    builder.Append("    resourceUri: ");
                    builder.AppendLine($"'{ResourceUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TermDuration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    termDuration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TermDuration))
                {
                    builder.Append("    termDuration: ");
                    var formattedTimeSpan = TypeFormatters.ToString(TermDuration.Value, "P");
                    builder.AppendLine($"'{formattedTimeSpan}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TermStartOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    termStartDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TermStartOn))
                {
                    builder.Append("    termStartDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(TermStartOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TermEndOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    termEndDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TermEndOn))
                {
                    builder.Append("    termEndDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(TermEndOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningTenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningTenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningTenantId))
                {
                    builder.Append("    provisioningTenantId: ");
                    builder.AppendLine($"'{ProvisioningTenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Status), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Status))
                {
                    builder.Append("    status: ");
                    builder.AppendLine($"'{Status.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OperationStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    operationStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OperationStatus))
                {
                    builder.Append("    operationStatus: ");
                    builder.AppendLine($"'{OperationStatus.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SubscriptionId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    subscriptionId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SubscriptionId))
                {
                    builder.Append("    subscriptionId: ");
                    if (SubscriptionId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SubscriptionId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SubscriptionId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SuspensionReasons), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    suspensionReasons: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SuspensionReasons))
                {
                    if (SuspensionReasons.Any())
                    {
                        builder.Append("    suspensionReasons: ");
                        builder.AppendLine("[");
                        foreach (var item in SuspensionReasons)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SuspensionReasonDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    suspensionReasonDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SuspensionReasonDetails))
                {
                    if (SuspensionReasonDetails.Any())
                    {
                        builder.Append("    suspensionReasonDetails: ");
                        builder.AppendLine("[");
                        foreach (var item in SuspensionReasonDetails)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    suspensionReasonDetails: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SubscriptionAliasSubscriptionId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    billingSubscriptionId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SubscriptionAliasSubscriptionId))
                {
                    builder.Append("    billingSubscriptionId: ");
                    if (SubscriptionAliasSubscriptionId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SubscriptionAliasSubscriptionId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SubscriptionAliasSubscriptionId}'");
                    }
                }
            }

            builder.Append("    enrollmentAccountSubscriptionDetails:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnrollmentAccountStartOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      enrollmentAccountStartDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnrollmentAccountStartOn))
                {
                    builder.Append("      enrollmentAccountStartDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(EnrollmentAccountStartOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SubscriptionEnrollmentAccountStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      subscriptionEnrollmentAccountStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SubscriptionEnrollmentAccountStatus))
                {
                    builder.Append("      subscriptionEnrollmentAccountStatus: ");
                    builder.AppendLine($"'{SubscriptionEnrollmentAccountStatus.Value.ToString()}'");
                }
            }

            builder.AppendLine("    }");
            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<BillingSubscriptionAliasData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingSubscriptionAliasData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(BillingSubscriptionAliasData)} does not support writing '{options.Format}' format.");
            }
        }

        BillingSubscriptionAliasData IPersistableModel<BillingSubscriptionAliasData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingSubscriptionAliasData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBillingSubscriptionAliasData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BillingSubscriptionAliasData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BillingSubscriptionAliasData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
