// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Billing.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing the BillingSavingsPlanModel data model.
    /// Savings plan
    /// </summary>
    public partial class BillingSavingsPlanModelData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingSavingsPlanModelData"/>. </summary>
        /// <param name="sku"> Savings plan SKU. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sku"/> is null. </exception>
        public BillingSavingsPlanModelData(BillingSku sku)
        {
            Argument.AssertNotNull(sku, nameof(sku));

            Sku = sku;
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="BillingSavingsPlanModelData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="sku"> Savings plan SKU. </param>
        /// <param name="displayName"> Display name. </param>
        /// <param name="provisioningState"> The provisioning state of the resource during a long-running operation. </param>
        /// <param name="displayProvisioningState"> The provisioning state of the savings plan for display, e.g. Succeeded. </param>
        /// <param name="userFriendlyAppliedScopeType"> The applied scope type of the savings plan for display, e.g. Shared. </param>
        /// <param name="billingScopeId"> Subscription that will be charged for purchasing SavingsPlan. </param>
        /// <param name="billingProfileId"> Fully-qualified identifier of the billing profile where the savings plan is applied. Present only for Field-led or Customer-led customers. </param>
        /// <param name="customerId"> Fully-qualified identifier of the customer where the savings plan is applied. Present only for Partner-led customers. </param>
        /// <param name="billingAccountId"> Fully-qualified identifier of the billing account where the savings plan is applied. </param>
        /// <param name="term"> Represents the Savings plan term in ISO 8601 format. </param>
        /// <param name="isRenewed"> Setting this to true will automatically purchase a new benefit on the expiration date time. </param>
        /// <param name="renewSource"> SavingsPlan Id of the SavingsPlan from which this SavingsPlan is renewed. </param>
        /// <param name="renewDestination"> SavingsPlan Id of the SavingsPlan which is purchased because of renew. </param>
        /// <param name="renewProperties"> Properties specific to renew. </param>
        /// <param name="billingPlan"> Represents the billing plan in ISO 8601 format. Required only for monthly purchases. </param>
        /// <param name="appliedScopeType"> Type of the Applied Scope. </param>
        /// <param name="appliedScopeProperties"> Properties specific to applied scope type. Not required if not applicable. </param>
        /// <param name="commitment"> Commitment towards the benefit. </param>
        /// <param name="effectiveOn"> DateTime of the savings plan starting when this version is effective from. </param>
        /// <param name="benefitStartOn"> This is the DateTime when the savings plan benefit starts. </param>
        /// <param name="expiryOn"> This is the date-time when the savings plan will expire. </param>
        /// <param name="purchaseOn"> Date time when the savings plan was purchased. </param>
        /// <param name="utilization"> Savings plan utilization. </param>
        /// <param name="extendedStatusInfo"> Extended status information. </param>
        /// <param name="productCode"> Represents UPN. </param>
        /// <param name="tags"> Dictionary of metadata associated with the resource. It may not be populated for all resource types. Maximum key/value length supported of 256 characters. Keys/value should not empty value nor null. Keys can not contain &lt; &gt; % &amp; \ ? /. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingSavingsPlanModelData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, BillingSku sku, string displayName, BillingProvisioningState? provisioningState, string displayProvisioningState, string userFriendlyAppliedScopeType, string billingScopeId, ResourceIdentifier billingProfileId, ResourceIdentifier customerId, ResourceIdentifier billingAccountId, BillingSavingsPlanTerm? term, bool? isRenewed, string renewSource, string renewDestination, BillingRenewProperties renewProperties, BillingPlan? billingPlan, BillingAppliedScopeType? appliedScopeType, BillingAppliedScopeProperties appliedScopeProperties, BillingBenefitCommitment commitment, DateTimeOffset? effectiveOn, DateTimeOffset? benefitStartOn, DateTimeOffset? expiryOn, DateTimeOffset? purchaseOn, SavingsPlanUtilization utilization, ExtendedStatusInfo extendedStatusInfo, string productCode, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Sku = sku;
            DisplayName = displayName;
            ProvisioningState = provisioningState;
            DisplayProvisioningState = displayProvisioningState;
            UserFriendlyAppliedScopeType = userFriendlyAppliedScopeType;
            BillingScopeId = billingScopeId;
            BillingProfileId = billingProfileId;
            CustomerId = customerId;
            BillingAccountId = billingAccountId;
            Term = term;
            IsRenewed = isRenewed;
            RenewSource = renewSource;
            RenewDestination = renewDestination;
            RenewProperties = renewProperties;
            BillingPlan = billingPlan;
            AppliedScopeType = appliedScopeType;
            AppliedScopeProperties = appliedScopeProperties;
            Commitment = commitment;
            EffectiveOn = effectiveOn;
            BenefitStartOn = benefitStartOn;
            ExpiryOn = expiryOn;
            PurchaseOn = purchaseOn;
            Utilization = utilization;
            ExtendedStatusInfo = extendedStatusInfo;
            ProductCode = productCode;
            Tags = tags;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BillingSavingsPlanModelData"/> for deserialization. </summary>
        internal BillingSavingsPlanModelData()
        {
        }

        /// <summary> Savings plan SKU. </summary>
        internal BillingSku Sku { get; set; }
        /// <summary> Name of the SKU to be applied. </summary>
        [WirePath("sku.name")]
        public string SkuName
        {
            get => Sku is null ? default : Sku.Name;
            set
            {
                if (Sku is null)
                    Sku = new BillingSku();
                Sku.Name = value;
            }
        }

        /// <summary> Display name. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> The provisioning state of the resource during a long-running operation. </summary>
        [WirePath("properties.provisioningState")]
        public BillingProvisioningState? ProvisioningState { get; set; }
        /// <summary> The provisioning state of the savings plan for display, e.g. Succeeded. </summary>
        [WirePath("properties.displayProvisioningState")]
        public string DisplayProvisioningState { get; }
        /// <summary> The applied scope type of the savings plan for display, e.g. Shared. </summary>
        [WirePath("properties.userFriendlyAppliedScopeType")]
        public string UserFriendlyAppliedScopeType { get; }
        /// <summary> Subscription that will be charged for purchasing SavingsPlan. </summary>
        [WirePath("properties.billingScopeId")]
        public string BillingScopeId { get; set; }
        /// <summary> Fully-qualified identifier of the billing profile where the savings plan is applied. Present only for Field-led or Customer-led customers. </summary>
        [WirePath("properties.billingProfileId")]
        public ResourceIdentifier BillingProfileId { get; }
        /// <summary> Fully-qualified identifier of the customer where the savings plan is applied. Present only for Partner-led customers. </summary>
        [WirePath("properties.customerId")]
        public ResourceIdentifier CustomerId { get; }
        /// <summary> Fully-qualified identifier of the billing account where the savings plan is applied. </summary>
        [WirePath("properties.billingAccountId")]
        public ResourceIdentifier BillingAccountId { get; }
        /// <summary> Represents the Savings plan term in ISO 8601 format. </summary>
        [WirePath("properties.term")]
        public BillingSavingsPlanTerm? Term { get; set; }
        /// <summary> Setting this to true will automatically purchase a new benefit on the expiration date time. </summary>
        [WirePath("properties.renew")]
        public bool? IsRenewed { get; set; }
        /// <summary> SavingsPlan Id of the SavingsPlan from which this SavingsPlan is renewed. </summary>
        [WirePath("properties.renewSource")]
        public string RenewSource { get; set; }
        /// <summary> SavingsPlan Id of the SavingsPlan which is purchased because of renew. </summary>
        [WirePath("properties.renewDestination")]
        public string RenewDestination { get; set; }
        /// <summary> Properties specific to renew. </summary>
        internal BillingRenewProperties RenewProperties { get; set; }
        /// <summary> Purchase request. </summary>
        [WirePath("properties.renewProperties.purchaseProperties")]
        public BillingPurchaseProperties RenewPurchaseProperties
        {
            get => RenewProperties is null ? default : RenewProperties.PurchaseProperties;
            set
            {
                if (RenewProperties is null)
                    RenewProperties = new BillingRenewProperties();
                RenewProperties.PurchaseProperties = value;
            }
        }

        /// <summary> Represents the billing plan in ISO 8601 format. Required only for monthly purchases. </summary>
        [WirePath("properties.billingPlan")]
        public BillingPlan? BillingPlan { get; set; }
        /// <summary> Type of the Applied Scope. </summary>
        [WirePath("properties.appliedScopeType")]
        public BillingAppliedScopeType? AppliedScopeType { get; set; }
        /// <summary> Properties specific to applied scope type. Not required if not applicable. </summary>
        [WirePath("properties.appliedScopeProperties")]
        public BillingAppliedScopeProperties AppliedScopeProperties { get; set; }
        /// <summary> Commitment towards the benefit. </summary>
        [WirePath("properties.commitment")]
        public BillingBenefitCommitment Commitment { get; set; }
        /// <summary> DateTime of the savings plan starting when this version is effective from. </summary>
        [WirePath("properties.effectiveDateTime")]
        public DateTimeOffset? EffectiveOn { get; }
        /// <summary> This is the DateTime when the savings plan benefit starts. </summary>
        [WirePath("properties.benefitStartTime")]
        public DateTimeOffset? BenefitStartOn { get; }
        /// <summary> This is the date-time when the savings plan will expire. </summary>
        [WirePath("properties.expiryDateTime")]
        public DateTimeOffset? ExpiryOn { get; }
        /// <summary> Date time when the savings plan was purchased. </summary>
        [WirePath("properties.purchaseDateTime")]
        public DateTimeOffset? PurchaseOn { get; }
        /// <summary> Savings plan utilization. </summary>
        [WirePath("properties.utilization")]
        public SavingsPlanUtilization Utilization { get; }
        /// <summary> Extended status information. </summary>
        [WirePath("properties.extendedStatusInfo")]
        public ExtendedStatusInfo ExtendedStatusInfo { get; }
        /// <summary> Represents UPN. </summary>
        [WirePath("properties.productCode")]
        public string ProductCode { get; set; }
        /// <summary> Dictionary of metadata associated with the resource. It may not be populated for all resource types. Maximum key/value length supported of 256 characters. Keys/value should not empty value nor null. Keys can not contain &lt; &gt; % &amp; \ ? /. </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
    }
}
