// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingSavingsPlanModelResource"/> and their operations.
    /// Each <see cref="BillingSavingsPlanModelResource"/> in the collection will belong to the same instance of <see cref="SavingsPlanOrderModelResource"/>.
    /// To get a <see cref="BillingSavingsPlanModelCollection"/> instance call the GetBillingSavingsPlanModels method from an instance of <see cref="SavingsPlanOrderModelResource"/>.
    /// </summary>
    public partial class BillingSavingsPlanModelCollection : ArmCollection, IEnumerable<BillingSavingsPlanModelResource>, IAsyncEnumerable<BillingSavingsPlanModelResource>
    {
        private readonly ClientDiagnostics _billingSavingsPlanModelSavingsPlansClientDiagnostics;
        private readonly SavingsPlansRestOperations _billingSavingsPlanModelSavingsPlansRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingSavingsPlanModelCollection"/> class for mocking. </summary>
        protected BillingSavingsPlanModelCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingSavingsPlanModelCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingSavingsPlanModelCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingSavingsPlanModelSavingsPlansClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingSavingsPlanModelResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingSavingsPlanModelResource.ResourceType, out string billingSavingsPlanModelSavingsPlansApiVersion);
            _billingSavingsPlanModelSavingsPlansRestClient = new SavingsPlansRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingSavingsPlanModelSavingsPlansApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SavingsPlanOrderModelResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SavingsPlanOrderModelResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get savings plan by billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}/savingsPlans/{savingsPlanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlans_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingSavingsPlanModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanId"/> is null. </exception>
        public virtual async Task<Response<BillingSavingsPlanModelResource>> GetAsync(string savingsPlanId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));

            using var scope = _billingSavingsPlanModelSavingsPlansClientDiagnostics.CreateScope("BillingSavingsPlanModelCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingSavingsPlanModelSavingsPlansRestClient.GetByBillingAccountAsync(Id.Parent.Name, Id.Name, savingsPlanId, expand, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingSavingsPlanModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get savings plan by billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}/savingsPlans/{savingsPlanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlans_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingSavingsPlanModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanId"/> is null. </exception>
        public virtual Response<BillingSavingsPlanModelResource> Get(string savingsPlanId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));

            using var scope = _billingSavingsPlanModelSavingsPlansClientDiagnostics.CreateScope("BillingSavingsPlanModelCollection.Get");
            scope.Start();
            try
            {
                var response = _billingSavingsPlanModelSavingsPlansRestClient.GetByBillingAccount(Id.Parent.Name, Id.Name, savingsPlanId, expand, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingSavingsPlanModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List savings plans in an order by billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}/savingsPlans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlans_ListBySavingsPlanOrder</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingSavingsPlanModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingSavingsPlanModelResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingSavingsPlanModelResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingSavingsPlanModelSavingsPlansRestClient.CreateListBySavingsPlanOrderRequest(Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingSavingsPlanModelSavingsPlansRestClient.CreateListBySavingsPlanOrderNextPageRequest(nextLink, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingSavingsPlanModelResource(Client, BillingSavingsPlanModelData.DeserializeBillingSavingsPlanModelData(e)), _billingSavingsPlanModelSavingsPlansClientDiagnostics, Pipeline, "BillingSavingsPlanModelCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List savings plans in an order by billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}/savingsPlans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlans_ListBySavingsPlanOrder</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingSavingsPlanModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingSavingsPlanModelResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingSavingsPlanModelResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingSavingsPlanModelSavingsPlansRestClient.CreateListBySavingsPlanOrderRequest(Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingSavingsPlanModelSavingsPlansRestClient.CreateListBySavingsPlanOrderNextPageRequest(nextLink, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingSavingsPlanModelResource(Client, BillingSavingsPlanModelData.DeserializeBillingSavingsPlanModelData(e)), _billingSavingsPlanModelSavingsPlansClientDiagnostics, Pipeline, "BillingSavingsPlanModelCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}/savingsPlans/{savingsPlanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlans_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingSavingsPlanModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string savingsPlanId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));

            using var scope = _billingSavingsPlanModelSavingsPlansClientDiagnostics.CreateScope("BillingSavingsPlanModelCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingSavingsPlanModelSavingsPlansRestClient.GetByBillingAccountAsync(Id.Parent.Name, Id.Name, savingsPlanId, expand, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}/savingsPlans/{savingsPlanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlans_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingSavingsPlanModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanId"/> is null. </exception>
        public virtual Response<bool> Exists(string savingsPlanId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));

            using var scope = _billingSavingsPlanModelSavingsPlansClientDiagnostics.CreateScope("BillingSavingsPlanModelCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingSavingsPlanModelSavingsPlansRestClient.GetByBillingAccount(Id.Parent.Name, Id.Name, savingsPlanId, expand, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}/savingsPlans/{savingsPlanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlans_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingSavingsPlanModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanId"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingSavingsPlanModelResource>> GetIfExistsAsync(string savingsPlanId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));

            using var scope = _billingSavingsPlanModelSavingsPlansClientDiagnostics.CreateScope("BillingSavingsPlanModelCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingSavingsPlanModelSavingsPlansRestClient.GetByBillingAccountAsync(Id.Parent.Name, Id.Name, savingsPlanId, expand, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingSavingsPlanModelResource>(response.GetRawResponse());
                return Response.FromValue(new BillingSavingsPlanModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}/savingsPlans/{savingsPlanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlans_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingSavingsPlanModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanId"/> is null. </exception>
        public virtual NullableResponse<BillingSavingsPlanModelResource> GetIfExists(string savingsPlanId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));

            using var scope = _billingSavingsPlanModelSavingsPlansClientDiagnostics.CreateScope("BillingSavingsPlanModelCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingSavingsPlanModelSavingsPlansRestClient.GetByBillingAccount(Id.Parent.Name, Id.Name, savingsPlanId, expand, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingSavingsPlanModelResource>(response.GetRawResponse());
                return Response.FromValue(new BillingSavingsPlanModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingSavingsPlanModelResource> IEnumerable<BillingSavingsPlanModelResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<BillingSavingsPlanModelResource> IAsyncEnumerable<BillingSavingsPlanModelResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
