// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Billing.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing the BillingReservationOrder data model.
    /// Details of a reservation order being returned.
    /// </summary>
    public partial class BillingReservationOrderData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingReservationOrderData"/>. </summary>
        public BillingReservationOrderData()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
            Reservations = new ChangeTrackingList<BillingReservationData>();
        }

        /// <summary> Initializes a new instance of <see cref="BillingReservationOrderData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"></param>
        /// <param name="tags"> Tags for this reservation. </param>
        /// <param name="displayName"> Friendly name for user to easily identified the reservation order. </param>
        /// <param name="enrollmentId"> Enrollment id of the reservation order. </param>
        /// <param name="customerId"> Fully-qualified identifier of the customerId where the benefit is applied. Present only for Enterprise Agreement PartnerLed customers. </param>
        /// <param name="billingProfileId"> Billing profile Id associated to this reservation order. </param>
        /// <param name="billingAccountId"> Billing account Id associated to this reservation order. </param>
        /// <param name="requestOn"> This is the DateTime when the reservation order was initially requested for purchase. </param>
        /// <param name="createdOn"> This is the DateTime when the reservation order was created. </param>
        /// <param name="expireOn"> This is the date when the reservation order will expire. </param>
        /// <param name="reservationExpireOn"> This is the date-time when the reservation order will expire. </param>
        /// <param name="benefitStartOn"> This is the DateTime when the reservation benefit started. </param>
        /// <param name="originalQuantity"> Total original quantity of the skus purchased in the reservation order. </param>
        /// <param name="term"> The term of the reservation, e.g. P1Y. </param>
        /// <param name="provisioningState"> The provisioning state of the reservation, e.g. Succeeded. </param>
        /// <param name="billingPlan"> Represent the billing plans. </param>
        /// <param name="planInformation"> Information describing the type of billing plan for this reservation order. </param>
        /// <param name="reservations"></param>
        /// <param name="reviewedOn"> This is the date-time when the Azure Hybrid Benefit needs to be reviewed. </param>
        /// <param name="extendedStatusInfo"> Extended status information for the reservation. </param>
        /// <param name="productCode"> Represents UPN. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingReservationOrderData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, int? etag, IDictionary<string, string> tags, string displayName, string enrollmentId, ResourceIdentifier customerId, ResourceIdentifier billingProfileId, ResourceIdentifier billingAccountId, DateTimeOffset? requestOn, DateTimeOffset? createdOn, DateTimeOffset? expireOn, DateTimeOffset? reservationExpireOn, DateTimeOffset? benefitStartOn, int? originalQuantity, string term, string provisioningState, ReservationBillingPlan? billingPlan, ReservationOrderBillingPlanInformation planInformation, IList<BillingReservationData> reservations, DateTimeOffset? reviewedOn, ReservationExtendedStatusInfo extendedStatusInfo, string productCode, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ETag = etag;
            Tags = tags;
            DisplayName = displayName;
            EnrollmentId = enrollmentId;
            CustomerId = customerId;
            BillingProfileId = billingProfileId;
            BillingAccountId = billingAccountId;
            RequestOn = requestOn;
            CreatedOn = createdOn;
            ExpireOn = expireOn;
            ReservationExpireOn = reservationExpireOn;
            BenefitStartOn = benefitStartOn;
            OriginalQuantity = originalQuantity;
            Term = term;
            ProvisioningState = provisioningState;
            BillingPlan = billingPlan;
            PlanInformation = planInformation;
            Reservations = reservations;
            ReviewedOn = reviewedOn;
            ExtendedStatusInfo = extendedStatusInfo;
            ProductCode = productCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the e tag. </summary>
        [WirePath("etag")]
        public int? ETag { get; set; }
        /// <summary> Tags for this reservation. </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
        /// <summary> Friendly name for user to easily identified the reservation order. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> Enrollment id of the reservation order. </summary>
        [WirePath("properties.enrollmentId")]
        public string EnrollmentId { get; set; }
        /// <summary> Fully-qualified identifier of the customerId where the benefit is applied. Present only for Enterprise Agreement PartnerLed customers. </summary>
        [WirePath("properties.customerId")]
        public ResourceIdentifier CustomerId { get; set; }
        /// <summary> Billing profile Id associated to this reservation order. </summary>
        [WirePath("properties.billingProfileId")]
        public ResourceIdentifier BillingProfileId { get; set; }
        /// <summary> Billing account Id associated to this reservation order. </summary>
        [WirePath("properties.billingAccountId")]
        public ResourceIdentifier BillingAccountId { get; set; }
        /// <summary> This is the DateTime when the reservation order was initially requested for purchase. </summary>
        [WirePath("properties.requestDateTime")]
        public DateTimeOffset? RequestOn { get; set; }
        /// <summary> This is the DateTime when the reservation order was created. </summary>
        [WirePath("properties.createdDateTime")]
        public DateTimeOffset? CreatedOn { get; set; }
        /// <summary> This is the date when the reservation order will expire. </summary>
        [WirePath("properties.expiryDate")]
        public DateTimeOffset? ExpireOn { get; set; }
        /// <summary> This is the date-time when the reservation order will expire. </summary>
        [WirePath("properties.expiryDateTime")]
        public DateTimeOffset? ReservationExpireOn { get; set; }
        /// <summary> This is the DateTime when the reservation benefit started. </summary>
        [WirePath("properties.benefitStartTime")]
        public DateTimeOffset? BenefitStartOn { get; set; }
        /// <summary> Total original quantity of the skus purchased in the reservation order. </summary>
        [WirePath("properties.originalQuantity")]
        public int? OriginalQuantity { get; set; }
        /// <summary> The term of the reservation, e.g. P1Y. </summary>
        [WirePath("properties.term")]
        public string Term { get; }
        /// <summary> The provisioning state of the reservation, e.g. Succeeded. </summary>
        [WirePath("properties.provisioningState")]
        public string ProvisioningState { get; }
        /// <summary> Represent the billing plans. </summary>
        [WirePath("properties.billingPlan")]
        public ReservationBillingPlan? BillingPlan { get; set; }
        /// <summary> Information describing the type of billing plan for this reservation order. </summary>
        [WirePath("properties.planInformation")]
        public ReservationOrderBillingPlanInformation PlanInformation { get; set; }
        /// <summary> Gets the reservations. </summary>
        [WirePath("properties.reservations")]
        public IList<BillingReservationData> Reservations { get; }
        /// <summary> This is the date-time when the Azure Hybrid Benefit needs to be reviewed. </summary>
        [WirePath("properties.reviewDateTime")]
        public DateTimeOffset? ReviewedOn { get; set; }
        /// <summary> Extended status information for the reservation. </summary>
        [WirePath("properties.extendedStatusInfo")]
        public ReservationExtendedStatusInfo ExtendedStatusInfo { get; set; }
        /// <summary> Represents UPN. </summary>
        [WirePath("properties.productCode")]
        public string ProductCode { get; set; }
    }
}
