// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingReservationOrderResource"/> and their operations.
    /// Each <see cref="BillingReservationOrderResource"/> in the collection will belong to the same instance of <see cref="BillingAccountResource"/>.
    /// To get a <see cref="BillingReservationOrderCollection"/> instance call the GetBillingReservationOrders method from an instance of <see cref="BillingAccountResource"/>.
    /// </summary>
    public partial class BillingReservationOrderCollection : ArmCollection, IEnumerable<BillingReservationOrderResource>, IAsyncEnumerable<BillingReservationOrderResource>
    {
        private readonly ClientDiagnostics _billingReservationOrderReservationOrdersClientDiagnostics;
        private readonly ReservationOrdersRestOperations _billingReservationOrderReservationOrdersRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingReservationOrderCollection"/> class for mocking. </summary>
        protected BillingReservationOrderCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingReservationOrderCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingReservationOrderCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingReservationOrderReservationOrdersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingReservationOrderResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingReservationOrderResource.ResourceType, out string billingReservationOrderReservationOrdersApiVersion);
            _billingReservationOrderReservationOrdersRestClient = new ReservationOrdersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingReservationOrderReservationOrdersApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get the details of the ReservationOrder in the billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/reservationOrders/{reservationOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ReservationOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingReservationOrderResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="reservationOrderId"> Order Id of the reservation. </param>
        /// <param name="expand"> May be used to expand the detail information of some properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="reservationOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="reservationOrderId"/> is null. </exception>
        public virtual async Task<Response<BillingReservationOrderResource>> GetAsync(string reservationOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reservationOrderId, nameof(reservationOrderId));

            using var scope = _billingReservationOrderReservationOrdersClientDiagnostics.CreateScope("BillingReservationOrderCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingReservationOrderReservationOrdersRestClient.GetByBillingAccountAsync(Id.Name, reservationOrderId, expand, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingReservationOrderResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the details of the ReservationOrder in the billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/reservationOrders/{reservationOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ReservationOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingReservationOrderResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="reservationOrderId"> Order Id of the reservation. </param>
        /// <param name="expand"> May be used to expand the detail information of some properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="reservationOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="reservationOrderId"/> is null. </exception>
        public virtual Response<BillingReservationOrderResource> Get(string reservationOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reservationOrderId, nameof(reservationOrderId));

            using var scope = _billingReservationOrderReservationOrdersClientDiagnostics.CreateScope("BillingReservationOrderCollection.Get");
            scope.Start();
            try
            {
                var response = _billingReservationOrderReservationOrdersRestClient.GetByBillingAccount(Id.Name, reservationOrderId, expand, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingReservationOrderResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List all the `ReservationOrders in the billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/reservationOrders</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ReservationOrders_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingReservationOrderResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> The filter query option allows clients to filter a collection of resources that are addressed by a request URL. </param>
        /// <param name="orderBy"> The orderby query option allows clients to request resources in a particular order. </param>
        /// <param name="skiptoken"> The number of reservations to skip from the list before returning results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingReservationOrderResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingReservationOrderResource> GetAllAsync(string filter = null, string orderBy = null, float? skiptoken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingReservationOrderReservationOrdersRestClient.CreateListByBillingAccountRequest(Id.Name, filter, orderBy, skiptoken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingReservationOrderReservationOrdersRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, filter, orderBy, skiptoken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingReservationOrderResource(Client, BillingReservationOrderData.DeserializeBillingReservationOrderData(e)), _billingReservationOrderReservationOrdersClientDiagnostics, Pipeline, "BillingReservationOrderCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List all the `ReservationOrders in the billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/reservationOrders</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ReservationOrders_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingReservationOrderResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> The filter query option allows clients to filter a collection of resources that are addressed by a request URL. </param>
        /// <param name="orderBy"> The orderby query option allows clients to request resources in a particular order. </param>
        /// <param name="skiptoken"> The number of reservations to skip from the list before returning results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingReservationOrderResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingReservationOrderResource> GetAll(string filter = null, string orderBy = null, float? skiptoken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingReservationOrderReservationOrdersRestClient.CreateListByBillingAccountRequest(Id.Name, filter, orderBy, skiptoken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingReservationOrderReservationOrdersRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, filter, orderBy, skiptoken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingReservationOrderResource(Client, BillingReservationOrderData.DeserializeBillingReservationOrderData(e)), _billingReservationOrderReservationOrdersClientDiagnostics, Pipeline, "BillingReservationOrderCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/reservationOrders/{reservationOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ReservationOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingReservationOrderResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="reservationOrderId"> Order Id of the reservation. </param>
        /// <param name="expand"> May be used to expand the detail information of some properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="reservationOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="reservationOrderId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string reservationOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reservationOrderId, nameof(reservationOrderId));

            using var scope = _billingReservationOrderReservationOrdersClientDiagnostics.CreateScope("BillingReservationOrderCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingReservationOrderReservationOrdersRestClient.GetByBillingAccountAsync(Id.Name, reservationOrderId, expand, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/reservationOrders/{reservationOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ReservationOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingReservationOrderResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="reservationOrderId"> Order Id of the reservation. </param>
        /// <param name="expand"> May be used to expand the detail information of some properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="reservationOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="reservationOrderId"/> is null. </exception>
        public virtual Response<bool> Exists(string reservationOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reservationOrderId, nameof(reservationOrderId));

            using var scope = _billingReservationOrderReservationOrdersClientDiagnostics.CreateScope("BillingReservationOrderCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingReservationOrderReservationOrdersRestClient.GetByBillingAccount(Id.Name, reservationOrderId, expand, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/reservationOrders/{reservationOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ReservationOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingReservationOrderResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="reservationOrderId"> Order Id of the reservation. </param>
        /// <param name="expand"> May be used to expand the detail information of some properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="reservationOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="reservationOrderId"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingReservationOrderResource>> GetIfExistsAsync(string reservationOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reservationOrderId, nameof(reservationOrderId));

            using var scope = _billingReservationOrderReservationOrdersClientDiagnostics.CreateScope("BillingReservationOrderCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingReservationOrderReservationOrdersRestClient.GetByBillingAccountAsync(Id.Name, reservationOrderId, expand, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingReservationOrderResource>(response.GetRawResponse());
                return Response.FromValue(new BillingReservationOrderResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/reservationOrders/{reservationOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ReservationOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingReservationOrderResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="reservationOrderId"> Order Id of the reservation. </param>
        /// <param name="expand"> May be used to expand the detail information of some properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="reservationOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="reservationOrderId"/> is null. </exception>
        public virtual NullableResponse<BillingReservationOrderResource> GetIfExists(string reservationOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reservationOrderId, nameof(reservationOrderId));

            using var scope = _billingReservationOrderReservationOrdersClientDiagnostics.CreateScope("BillingReservationOrderCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingReservationOrderReservationOrdersRestClient.GetByBillingAccount(Id.Name, reservationOrderId, expand, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingReservationOrderResource>(response.GetRawResponse());
                return Response.FromValue(new BillingReservationOrderResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingReservationOrderResource> IEnumerable<BillingReservationOrderResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<BillingReservationOrderResource> IAsyncEnumerable<BillingReservationOrderResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
