// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Billing.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing the BillingReservation data model.
    /// The definition of the reservation.
    /// </summary>
    public partial class BillingReservationData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingReservationData"/>. </summary>
        /// <param name="location"> The location. </param>
        public BillingReservationData(AzureLocation location) : base(location)
        {
            AppliedScopes = new ChangeTrackingList<string>();
            Aggregates = new ChangeTrackingList<ReservationUtilizationAggregates>();
        }

        /// <summary> Initializes a new instance of <see cref="BillingReservationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"></param>
        /// <param name="sku"> The sku information associated to this reservation. </param>
        /// <param name="reservedResourceType"> The reserved source type of the reservation, e.g. virtual machine. </param>
        /// <param name="instanceFlexibility"> Allows reservation discount to be applied across skus within the same auto fit group. Not all skus support instance size flexibility. </param>
        /// <param name="displayName"> The display name of the reservation. </param>
        /// <param name="appliedScopes"> The array of applied scopes of a reservation. Will be null if the reservation is in Shared scope. </param>
        /// <param name="appliedScopeType"> The applied scope type of the reservation. </param>
        /// <param name="isArchived"> Indicates if the reservation is archived. </param>
        /// <param name="capabilities"> Capabilities of the reservation. </param>
        /// <param name="quantity"> The number of the reservation. </param>
        /// <param name="provisioningState"> The provisioning state of the reservation, e.g. Succeeded. </param>
        /// <param name="effectiveOn"> The effective date time of the reservation. </param>
        /// <param name="benefitStartOn"> This is the DateTime when the reservation benefit started. </param>
        /// <param name="lastUpdatedOn"> DateTime of the last time the reservation was updated. </param>
        /// <param name="expireOn"> The expiry date of the reservation. </param>
        /// <param name="reservationExpireOn"> This is the date-time when the reservation will expire. </param>
        /// <param name="reviewOn"> This is the date-time when the Azure Hybrid Benefit needs to be reviewed. </param>
        /// <param name="skuDescription"> The sku description of the reservation. </param>
        /// <param name="extendedStatusInfo"> The message giving detailed information about the status code. </param>
        /// <param name="billingPlan"> The billing plan options available for this sku. </param>
        /// <param name="displayProvisioningState"> The provisioning state of the reservation for display, e.g. Succeeded. </param>
        /// <param name="provisioningSubState"> The provisioning state of the reservation, e.g. Succeeded. </param>
        /// <param name="purchaseOn"> This is the date when the reservation was purchased. </param>
        /// <param name="reservationPurchaseOn"> This is the date-time when the reservation was purchased. </param>
        /// <param name="splitProperties"> Properties of reservation split. </param>
        /// <param name="mergeProperties"> Properties of reservation merge. </param>
        /// <param name="swapProperties"> Properties of reservation swap. </param>
        /// <param name="appliedScopeProperties"> Properties specific to applied scope type. Not required if not applicable. Required and need to provide tenantId and managementGroupId if AppliedScopeType is ManagementGroup. </param>
        /// <param name="billingScopeId"> Subscription that will be charged for purchasing reservation or savings plan. </param>
        /// <param name="isRenewed"> The renew state of the reservation. </param>
        /// <param name="renewSource"> The renew source of the reservation. </param>
        /// <param name="renewDestination"> Reservation Id of the reservation which is purchased because of renew. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}. </param>
        /// <param name="renewProperties"> The renew properties for a reservation. </param>
        /// <param name="term"> The term of the reservation, e.g. P1Y. </param>
        /// <param name="userFriendlyAppliedScopeType"> The applied scope type of the reservation for display, e.g. Shared. </param>
        /// <param name="userFriendlyRenewState"> The renew state of the reservation for display, e.g. On. </param>
        /// <param name="productCode"> Represents UPN. </param>
        /// <param name="trend"> last 7 day utilization trend for a reservation. </param>
        /// <param name="aggregates"> The array of aggregates of a reservation's utilization. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingReservationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, int? etag, ReservationSkuProperty sku, string reservedResourceType, InstanceFlexibility? instanceFlexibility, string displayName, IList<string> appliedScopes, string appliedScopeType, bool? isArchived, string capabilities, float? quantity, string provisioningState, DateTimeOffset? effectiveOn, DateTimeOffset? benefitStartOn, DateTimeOffset? lastUpdatedOn, DateTimeOffset? expireOn, DateTimeOffset? reservationExpireOn, DateTimeOffset? reviewOn, string skuDescription, ReservationExtendedStatusInfo extendedStatusInfo, ReservationBillingPlan? billingPlan, string displayProvisioningState, string provisioningSubState, DateTimeOffset? purchaseOn, DateTimeOffset? reservationPurchaseOn, ReservationSplitProperties splitProperties, ReservationMergeProperties mergeProperties, ReservationSwapProperties swapProperties, ReservationAppliedScopeProperties appliedScopeProperties, string billingScopeId, bool? isRenewed, string renewSource, string renewDestination, ReservationRenewProperties renewProperties, string term, string userFriendlyAppliedScopeType, string userFriendlyRenewState, string productCode, string trend, IList<ReservationUtilizationAggregates> aggregates, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ETag = etag;
            Sku = sku;
            ReservedResourceType = reservedResourceType;
            InstanceFlexibility = instanceFlexibility;
            DisplayName = displayName;
            AppliedScopes = appliedScopes;
            AppliedScopeType = appliedScopeType;
            IsArchived = isArchived;
            Capabilities = capabilities;
            Quantity = quantity;
            ProvisioningState = provisioningState;
            EffectiveOn = effectiveOn;
            BenefitStartOn = benefitStartOn;
            LastUpdatedOn = lastUpdatedOn;
            ExpireOn = expireOn;
            ReservationExpireOn = reservationExpireOn;
            ReviewOn = reviewOn;
            SkuDescription = skuDescription;
            ExtendedStatusInfo = extendedStatusInfo;
            BillingPlan = billingPlan;
            DisplayProvisioningState = displayProvisioningState;
            ProvisioningSubState = provisioningSubState;
            PurchaseOn = purchaseOn;
            ReservationPurchaseOn = reservationPurchaseOn;
            SplitProperties = splitProperties;
            MergeProperties = mergeProperties;
            SwapProperties = swapProperties;
            AppliedScopeProperties = appliedScopeProperties;
            BillingScopeId = billingScopeId;
            IsRenewed = isRenewed;
            RenewSource = renewSource;
            RenewDestination = renewDestination;
            RenewProperties = renewProperties;
            Term = term;
            UserFriendlyAppliedScopeType = userFriendlyAppliedScopeType;
            UserFriendlyRenewState = userFriendlyRenewState;
            ProductCode = productCode;
            Trend = trend;
            Aggregates = aggregates;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BillingReservationData"/> for deserialization. </summary>
        internal BillingReservationData()
        {
        }

        /// <summary> Gets or sets the e tag. </summary>
        [WirePath("etag")]
        public int? ETag { get; set; }
        /// <summary> The sku information associated to this reservation. </summary>
        internal ReservationSkuProperty Sku { get; set; }
        /// <summary> The name of the reservation sku. </summary>
        [WirePath("sku.name")]
        public string SkuName
        {
            get => Sku is null ? default : Sku.Name;
        }

        /// <summary> The reserved source type of the reservation, e.g. virtual machine. </summary>
        [WirePath("properties.reservedResourceType")]
        public string ReservedResourceType { get; }
        /// <summary> Allows reservation discount to be applied across skus within the same auto fit group. Not all skus support instance size flexibility. </summary>
        [WirePath("properties.instanceFlexibility")]
        public InstanceFlexibility? InstanceFlexibility { get; set; }
        /// <summary> The display name of the reservation. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; }
        /// <summary> The array of applied scopes of a reservation. Will be null if the reservation is in Shared scope. </summary>
        [WirePath("properties.appliedScopes")]
        public IList<string> AppliedScopes { get; }
        /// <summary> The applied scope type of the reservation. </summary>
        [WirePath("properties.appliedScopeType")]
        public string AppliedScopeType { get; }
        /// <summary> Indicates if the reservation is archived. </summary>
        [WirePath("properties.archived")]
        public bool? IsArchived { get; set; }
        /// <summary> Capabilities of the reservation. </summary>
        [WirePath("properties.capabilities")]
        public string Capabilities { get; set; }
        /// <summary> The number of the reservation. </summary>
        [WirePath("properties.quantity")]
        public float? Quantity { get; }
        /// <summary> The provisioning state of the reservation, e.g. Succeeded. </summary>
        [WirePath("properties.provisioningState")]
        public string ProvisioningState { get; }
        /// <summary> The effective date time of the reservation. </summary>
        [WirePath("properties.effectiveDateTime")]
        public DateTimeOffset? EffectiveOn { get; }
        /// <summary> This is the DateTime when the reservation benefit started. </summary>
        [WirePath("properties.benefitStartTime")]
        public DateTimeOffset? BenefitStartOn { get; set; }
        /// <summary> DateTime of the last time the reservation was updated. </summary>
        [WirePath("properties.lastUpdatedDateTime")]
        public DateTimeOffset? LastUpdatedOn { get; }
        /// <summary> The expiry date of the reservation. </summary>
        [WirePath("properties.expiryDate")]
        public DateTimeOffset? ExpireOn { get; }
        /// <summary> This is the date-time when the reservation will expire. </summary>
        [WirePath("properties.expiryDateTime")]
        public DateTimeOffset? ReservationExpireOn { get; set; }
        /// <summary> This is the date-time when the Azure Hybrid Benefit needs to be reviewed. </summary>
        [WirePath("properties.reviewDateTime")]
        public DateTimeOffset? ReviewOn { get; set; }
        /// <summary> The sku description of the reservation. </summary>
        [WirePath("properties.skuDescription")]
        public string SkuDescription { get; }
        /// <summary> The message giving detailed information about the status code. </summary>
        [WirePath("properties.extendedStatusInfo")]
        public ReservationExtendedStatusInfo ExtendedStatusInfo { get; set; }
        /// <summary> The billing plan options available for this sku. </summary>
        [WirePath("properties.billingPlan")]
        public ReservationBillingPlan? BillingPlan { get; set; }
        /// <summary> The provisioning state of the reservation for display, e.g. Succeeded. </summary>
        [WirePath("properties.displayProvisioningState")]
        public string DisplayProvisioningState { get; }
        /// <summary> The provisioning state of the reservation, e.g. Succeeded. </summary>
        [WirePath("properties.provisioningSubState")]
        public string ProvisioningSubState { get; }
        /// <summary> This is the date when the reservation was purchased. </summary>
        [WirePath("properties.purchaseDate")]
        public DateTimeOffset? PurchaseOn { get; set; }
        /// <summary> This is the date-time when the reservation was purchased. </summary>
        [WirePath("properties.purchaseDateTime")]
        public DateTimeOffset? ReservationPurchaseOn { get; set; }
        /// <summary> Properties of reservation split. </summary>
        [WirePath("properties.splitProperties")]
        public ReservationSplitProperties SplitProperties { get; set; }
        /// <summary> Properties of reservation merge. </summary>
        [WirePath("properties.mergeProperties")]
        public ReservationMergeProperties MergeProperties { get; set; }
        /// <summary> Properties of reservation swap. </summary>
        [WirePath("properties.swapProperties")]
        public ReservationSwapProperties SwapProperties { get; set; }
        /// <summary> Properties specific to applied scope type. Not required if not applicable. Required and need to provide tenantId and managementGroupId if AppliedScopeType is ManagementGroup. </summary>
        [WirePath("properties.appliedScopeProperties")]
        public ReservationAppliedScopeProperties AppliedScopeProperties { get; set; }
        /// <summary> Subscription that will be charged for purchasing reservation or savings plan. </summary>
        [WirePath("properties.billingScopeId")]
        public string BillingScopeId { get; }
        /// <summary> The renew state of the reservation. </summary>
        [WirePath("properties.renew")]
        public bool? IsRenewed { get; }
        /// <summary> The renew source of the reservation. </summary>
        [WirePath("properties.renewSource")]
        public string RenewSource { get; }
        /// <summary> Reservation Id of the reservation which is purchased because of renew. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}. </summary>
        [WirePath("properties.renewDestination")]
        public string RenewDestination { get; set; }
        /// <summary> The renew properties for a reservation. </summary>
        [WirePath("properties.renewProperties")]
        public ReservationRenewProperties RenewProperties { get; set; }
        /// <summary> The term of the reservation, e.g. P1Y. </summary>
        [WirePath("properties.term")]
        public string Term { get; }
        /// <summary> The applied scope type of the reservation for display, e.g. Shared. </summary>
        [WirePath("properties.userFriendlyAppliedScopeType")]
        public string UserFriendlyAppliedScopeType { get; }
        /// <summary> The renew state of the reservation for display, e.g. On. </summary>
        [WirePath("properties.userFriendlyRenewState")]
        public string UserFriendlyRenewState { get; }
        /// <summary> Represents UPN. </summary>
        [WirePath("properties.productCode")]
        public string ProductCode { get; set; }
        /// <summary> last 7 day utilization trend for a reservation. </summary>
        [WirePath("properties.trend")]
        public string Trend { get; }
        /// <summary> The array of aggregates of a reservation's utilization. </summary>
        [WirePath("properties.aggregates")]
        public IList<ReservationUtilizationAggregates> Aggregates { get; }
    }
}
