// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingRequestResource"/> and their operations.
    /// Each <see cref="BillingRequestResource"/> in the collection will belong to the same instance of <see cref="TenantResource"/>.
    /// To get a <see cref="BillingRequestCollection"/> instance call the GetBillingRequests method from an instance of <see cref="TenantResource"/>.
    /// </summary>
    public partial class BillingRequestCollection : ArmCollection, IEnumerable<BillingRequestResource>, IAsyncEnumerable<BillingRequestResource>
    {
        private readonly ClientDiagnostics _billingRequestClientDiagnostics;
        private readonly BillingRequestsRestOperations _billingRequestRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingRequestCollection"/> class for mocking. </summary>
        protected BillingRequestCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingRequestCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingRequestCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingRequestClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingRequestResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingRequestResource.ResourceType, out string billingRequestApiVersion);
            _billingRequestRestClient = new BillingRequestsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingRequestApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != TenantResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, TenantResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create or update a billing request.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingRequests/{billingRequestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRequests_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingRequestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="billingRequestName"> The ID that uniquely identifies a billing request. </param>
        /// <param name="data"> A request submitted by a user to manage billing. Users with an owner role on the scope can approve or decline these requests. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRequestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRequestName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<BillingRequestResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string billingRequestName, BillingRequestData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRequestName, nameof(billingRequestName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _billingRequestClientDiagnostics.CreateScope("BillingRequestCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _billingRequestRestClient.CreateOrUpdateAsync(billingRequestName, data, cancellationToken).ConfigureAwait(false);
                var operation = new BillingArmOperation<BillingRequestResource>(new BillingRequestOperationSource(Client), _billingRequestClientDiagnostics, Pipeline, _billingRequestRestClient.CreateCreateOrUpdateRequest(billingRequestName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update a billing request.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingRequests/{billingRequestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRequests_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingRequestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="billingRequestName"> The ID that uniquely identifies a billing request. </param>
        /// <param name="data"> A request submitted by a user to manage billing. Users with an owner role on the scope can approve or decline these requests. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRequestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRequestName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<BillingRequestResource> CreateOrUpdate(WaitUntil waitUntil, string billingRequestName, BillingRequestData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRequestName, nameof(billingRequestName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _billingRequestClientDiagnostics.CreateScope("BillingRequestCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _billingRequestRestClient.CreateOrUpdate(billingRequestName, data, cancellationToken);
                var operation = new BillingArmOperation<BillingRequestResource>(new BillingRequestOperationSource(Client), _billingRequestClientDiagnostics, Pipeline, _billingRequestRestClient.CreateCreateOrUpdateRequest(billingRequestName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a billing request by its ID.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingRequests/{billingRequestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingRequestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRequestName"> The ID that uniquely identifies a billing request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRequestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRequestName"/> is null. </exception>
        public virtual async Task<Response<BillingRequestResource>> GetAsync(string billingRequestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRequestName, nameof(billingRequestName));

            using var scope = _billingRequestClientDiagnostics.CreateScope("BillingRequestCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingRequestRestClient.GetAsync(billingRequestName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingRequestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a billing request by its ID.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingRequests/{billingRequestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingRequestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRequestName"> The ID that uniquely identifies a billing request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRequestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRequestName"/> is null. </exception>
        public virtual Response<BillingRequestResource> Get(string billingRequestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRequestName, nameof(billingRequestName));

            using var scope = _billingRequestClientDiagnostics.CreateScope("BillingRequestCollection.Get");
            scope.Start();
            try
            {
                var response = _billingRequestRestClient.Get(billingRequestName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingRequestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The list of billing requests submitted by a user.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingRequests</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRequests_ListByUser</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingRequestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingRequestResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingRequestResource> GetAllAsync(BillingRequestCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingRequestCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingRequestRestClient.CreateListByUserRequest(options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingRequestRestClient.CreateListByUserNextPageRequest(nextLink, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingRequestResource(Client, BillingRequestData.DeserializeBillingRequestData(e)), _billingRequestClientDiagnostics, Pipeline, "BillingRequestCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// The list of billing requests submitted by a user.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingRequests</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRequests_ListByUser</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingRequestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingRequestResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingRequestResource> GetAll(BillingRequestCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingRequestCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingRequestRestClient.CreateListByUserRequest(options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingRequestRestClient.CreateListByUserNextPageRequest(nextLink, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingRequestResource(Client, BillingRequestData.DeserializeBillingRequestData(e)), _billingRequestClientDiagnostics, Pipeline, "BillingRequestCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingRequests/{billingRequestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingRequestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRequestName"> The ID that uniquely identifies a billing request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRequestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRequestName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string billingRequestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRequestName, nameof(billingRequestName));

            using var scope = _billingRequestClientDiagnostics.CreateScope("BillingRequestCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingRequestRestClient.GetAsync(billingRequestName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingRequests/{billingRequestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingRequestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRequestName"> The ID that uniquely identifies a billing request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRequestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRequestName"/> is null. </exception>
        public virtual Response<bool> Exists(string billingRequestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRequestName, nameof(billingRequestName));

            using var scope = _billingRequestClientDiagnostics.CreateScope("BillingRequestCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingRequestRestClient.Get(billingRequestName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingRequests/{billingRequestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingRequestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRequestName"> The ID that uniquely identifies a billing request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRequestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRequestName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingRequestResource>> GetIfExistsAsync(string billingRequestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRequestName, nameof(billingRequestName));

            using var scope = _billingRequestClientDiagnostics.CreateScope("BillingRequestCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingRequestRestClient.GetAsync(billingRequestName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingRequestResource>(response.GetRawResponse());
                return Response.FromValue(new BillingRequestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingRequests/{billingRequestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingRequestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRequestName"> The ID that uniquely identifies a billing request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRequestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRequestName"/> is null. </exception>
        public virtual NullableResponse<BillingRequestResource> GetIfExists(string billingRequestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRequestName, nameof(billingRequestName));

            using var scope = _billingRequestClientDiagnostics.CreateScope("BillingRequestCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingRequestRestClient.Get(billingRequestName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingRequestResource>(response.GetRawResponse());
                return Response.FromValue(new BillingRequestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingRequestResource> IEnumerable<BillingRequestResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<BillingRequestResource> IAsyncEnumerable<BillingRequestResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
