// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingProfileCustomerPolicyResource"/> and their operations.
    /// Each <see cref="BillingProfileCustomerPolicyResource"/> in the collection will belong to the same instance of <see cref="BillingProfileCustomerResource"/>.
    /// To get a <see cref="BillingProfileCustomerPolicyCollection"/> instance call the GetBillingProfileCustomerPolicies method from an instance of <see cref="BillingProfileCustomerResource"/>.
    /// </summary>
    public partial class BillingProfileCustomerPolicyCollection : ArmCollection
    {
        private readonly ClientDiagnostics _billingProfileCustomerPolicyPoliciesClientDiagnostics;
        private readonly PoliciesRestOperations _billingProfileCustomerPolicyPoliciesRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingProfileCustomerPolicyCollection"/> class for mocking. </summary>
        protected BillingProfileCustomerPolicyCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingProfileCustomerPolicyCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingProfileCustomerPolicyCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingProfileCustomerPolicyPoliciesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingProfileCustomerPolicyResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingProfileCustomerPolicyResource.ResourceType, out string billingProfileCustomerPolicyPoliciesApiVersion);
            _billingProfileCustomerPolicyPoliciesRestClient = new PoliciesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingProfileCustomerPolicyPoliciesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingProfileCustomerResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingProfileCustomerResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Lists the policies for a customer. This operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}/policies/{policyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Policies_GetByCustomer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerPolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="policyName"> Service-defined resource names such as 'default' which are reserved resource names. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<BillingProfileCustomerPolicyResource>> GetAsync(ServiceDefinedResourceName policyName, CancellationToken cancellationToken = default)
        {
            using var scope = _billingProfileCustomerPolicyPoliciesClientDiagnostics.CreateScope("BillingProfileCustomerPolicyCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingProfileCustomerPolicyPoliciesRestClient.GetByCustomerAsync(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, policyName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingProfileCustomerPolicyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the policies for a customer. This operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}/policies/{policyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Policies_GetByCustomer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerPolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="policyName"> Service-defined resource names such as 'default' which are reserved resource names. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<BillingProfileCustomerPolicyResource> Get(ServiceDefinedResourceName policyName, CancellationToken cancellationToken = default)
        {
            using var scope = _billingProfileCustomerPolicyPoliciesClientDiagnostics.CreateScope("BillingProfileCustomerPolicyCollection.Get");
            scope.Start();
            try
            {
                var response = _billingProfileCustomerPolicyPoliciesRestClient.GetByCustomer(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, policyName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingProfileCustomerPolicyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}/policies/{policyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Policies_GetByCustomer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerPolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="policyName"> Service-defined resource names such as 'default' which are reserved resource names. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(ServiceDefinedResourceName policyName, CancellationToken cancellationToken = default)
        {
            using var scope = _billingProfileCustomerPolicyPoliciesClientDiagnostics.CreateScope("BillingProfileCustomerPolicyCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingProfileCustomerPolicyPoliciesRestClient.GetByCustomerAsync(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, policyName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}/policies/{policyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Policies_GetByCustomer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerPolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="policyName"> Service-defined resource names such as 'default' which are reserved resource names. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(ServiceDefinedResourceName policyName, CancellationToken cancellationToken = default)
        {
            using var scope = _billingProfileCustomerPolicyPoliciesClientDiagnostics.CreateScope("BillingProfileCustomerPolicyCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingProfileCustomerPolicyPoliciesRestClient.GetByCustomer(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, policyName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}/policies/{policyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Policies_GetByCustomer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerPolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="policyName"> Service-defined resource names such as 'default' which are reserved resource names. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<BillingProfileCustomerPolicyResource>> GetIfExistsAsync(ServiceDefinedResourceName policyName, CancellationToken cancellationToken = default)
        {
            using var scope = _billingProfileCustomerPolicyPoliciesClientDiagnostics.CreateScope("BillingProfileCustomerPolicyCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingProfileCustomerPolicyPoliciesRestClient.GetByCustomerAsync(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, policyName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingProfileCustomerPolicyResource>(response.GetRawResponse());
                return Response.FromValue(new BillingProfileCustomerPolicyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}/policies/{policyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Policies_GetByCustomer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerPolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="policyName"> Service-defined resource names such as 'default' which are reserved resource names. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<BillingProfileCustomerPolicyResource> GetIfExists(ServiceDefinedResourceName policyName, CancellationToken cancellationToken = default)
        {
            using var scope = _billingProfileCustomerPolicyPoliciesClientDiagnostics.CreateScope("BillingProfileCustomerPolicyCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingProfileCustomerPolicyPoliciesRestClient.GetByCustomer(Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, policyName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingProfileCustomerPolicyResource>(response.GetRawResponse());
                return Response.FromValue(new BillingProfileCustomerPolicyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
