// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingProfileCustomerResource"/> and their operations.
    /// Each <see cref="BillingProfileCustomerResource"/> in the collection will belong to the same instance of <see cref="BillingProfileResource"/>.
    /// To get a <see cref="BillingProfileCustomerCollection"/> instance call the GetBillingProfileCustomers method from an instance of <see cref="BillingProfileResource"/>.
    /// </summary>
    public partial class BillingProfileCustomerCollection : ArmCollection, IEnumerable<BillingProfileCustomerResource>, IAsyncEnumerable<BillingProfileCustomerResource>
    {
        private readonly ClientDiagnostics _billingProfileCustomerCustomersClientDiagnostics;
        private readonly CustomersRestOperations _billingProfileCustomerCustomersRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingProfileCustomerCollection"/> class for mocking. </summary>
        protected BillingProfileCustomerCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingProfileCustomerCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingProfileCustomerCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingProfileCustomerCustomersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingProfileCustomerResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingProfileCustomerResource.ResourceType, out string billingProfileCustomerCustomersApiVersion);
            _billingProfileCustomerCustomersRestClient = new CustomersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingProfileCustomerCustomersApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingProfileResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingProfileResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a customer by its ID. The operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Customers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="customerName"> The ID that uniquely identifies a customer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="customerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="customerName"/> is null. </exception>
        public virtual async Task<Response<BillingProfileCustomerResource>> GetAsync(string customerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(customerName, nameof(customerName));

            using var scope = _billingProfileCustomerCustomersClientDiagnostics.CreateScope("BillingProfileCustomerCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingProfileCustomerCustomersRestClient.GetAsync(Id.Parent.Name, Id.Name, customerName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingProfileCustomerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a customer by its ID. The operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Customers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="customerName"> The ID that uniquely identifies a customer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="customerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="customerName"/> is null. </exception>
        public virtual Response<BillingProfileCustomerResource> Get(string customerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(customerName, nameof(customerName));

            using var scope = _billingProfileCustomerCustomersClientDiagnostics.CreateScope("BillingProfileCustomerCollection.Get");
            scope.Start();
            try
            {
                var response = _billingProfileCustomerCustomersRestClient.Get(Id.Parent.Name, Id.Name, customerName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingProfileCustomerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the customers that are billed to a billing profile. The operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Customers_ListByBillingProfile</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingProfileCustomerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingProfileCustomerResource> GetAllAsync(BillingProfileCustomerCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingProfileCustomerCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingProfileCustomerCustomersRestClient.CreateListByBillingProfileRequest(Id.Parent.Name, Id.Name, options.Expand, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingProfileCustomerCustomersRestClient.CreateListByBillingProfileNextPageRequest(nextLink, Id.Parent.Name, Id.Name, options.Expand, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingProfileCustomerResource(Client, BillingCustomerData.DeserializeBillingCustomerData(e)), _billingProfileCustomerCustomersClientDiagnostics, Pipeline, "BillingProfileCustomerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the customers that are billed to a billing profile. The operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Customers_ListByBillingProfile</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingProfileCustomerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingProfileCustomerResource> GetAll(BillingProfileCustomerCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingProfileCustomerCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingProfileCustomerCustomersRestClient.CreateListByBillingProfileRequest(Id.Parent.Name, Id.Name, options.Expand, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingProfileCustomerCustomersRestClient.CreateListByBillingProfileNextPageRequest(nextLink, Id.Parent.Name, Id.Name, options.Expand, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingProfileCustomerResource(Client, BillingCustomerData.DeserializeBillingCustomerData(e)), _billingProfileCustomerCustomersClientDiagnostics, Pipeline, "BillingProfileCustomerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Customers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="customerName"> The ID that uniquely identifies a customer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="customerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="customerName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string customerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(customerName, nameof(customerName));

            using var scope = _billingProfileCustomerCustomersClientDiagnostics.CreateScope("BillingProfileCustomerCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingProfileCustomerCustomersRestClient.GetAsync(Id.Parent.Name, Id.Name, customerName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Customers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="customerName"> The ID that uniquely identifies a customer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="customerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="customerName"/> is null. </exception>
        public virtual Response<bool> Exists(string customerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(customerName, nameof(customerName));

            using var scope = _billingProfileCustomerCustomersClientDiagnostics.CreateScope("BillingProfileCustomerCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingProfileCustomerCustomersRestClient.Get(Id.Parent.Name, Id.Name, customerName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Customers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="customerName"> The ID that uniquely identifies a customer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="customerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="customerName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingProfileCustomerResource>> GetIfExistsAsync(string customerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(customerName, nameof(customerName));

            using var scope = _billingProfileCustomerCustomersClientDiagnostics.CreateScope("BillingProfileCustomerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingProfileCustomerCustomersRestClient.GetAsync(Id.Parent.Name, Id.Name, customerName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingProfileCustomerResource>(response.GetRawResponse());
                return Response.FromValue(new BillingProfileCustomerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/customers/{customerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Customers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProfileCustomerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="customerName"> The ID that uniquely identifies a customer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="customerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="customerName"/> is null. </exception>
        public virtual NullableResponse<BillingProfileCustomerResource> GetIfExists(string customerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(customerName, nameof(customerName));

            using var scope = _billingProfileCustomerCustomersClientDiagnostics.CreateScope("BillingProfileCustomerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingProfileCustomerCustomersRestClient.Get(Id.Parent.Name, Id.Name, customerName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingProfileCustomerResource>(response.GetRawResponse());
                return Response.FromValue(new BillingProfileCustomerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingProfileCustomerResource> IEnumerable<BillingProfileCustomerResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<BillingProfileCustomerResource> IAsyncEnumerable<BillingProfileCustomerResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
