// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingProductResource"/> and their operations.
    /// Each <see cref="BillingProductResource"/> in the collection will belong to the same instance of <see cref="BillingAccountResource"/>.
    /// To get a <see cref="BillingProductCollection"/> instance call the GetBillingProducts method from an instance of <see cref="BillingAccountResource"/>.
    /// </summary>
    public partial class BillingProductCollection : ArmCollection, IEnumerable<BillingProductResource>, IAsyncEnumerable<BillingProductResource>
    {
        private readonly ClientDiagnostics _billingProductProductsClientDiagnostics;
        private readonly ProductsRestOperations _billingProductProductsRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingProductCollection"/> class for mocking. </summary>
        protected BillingProductCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingProductCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingProductCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingProductProductsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingProductResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingProductResource.ResourceType, out string billingProductProductsApiVersion);
            _billingProductProductsRestClient = new ProductsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingProductProductsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a product by ID. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/products/{productName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Products_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProductResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productName"> The ID that uniquely identifies a product. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productName"/> is null. </exception>
        public virtual async Task<Response<BillingProductResource>> GetAsync(string productName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productName, nameof(productName));

            using var scope = _billingProductProductsClientDiagnostics.CreateScope("BillingProductCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingProductProductsRestClient.GetAsync(Id.Name, productName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingProductResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a product by ID. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/products/{productName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Products_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProductResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productName"> The ID that uniquely identifies a product. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productName"/> is null. </exception>
        public virtual Response<BillingProductResource> Get(string productName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productName, nameof(productName));

            using var scope = _billingProductProductsClientDiagnostics.CreateScope("BillingProductCollection.Get");
            scope.Start();
            try
            {
                var response = _billingProductProductsRestClient.Get(Id.Name, productName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingProductResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the products for a billing account. These don't include products billed based on usage. The operation is supported for billing accounts with agreement type Microsoft Customer Agreement or Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/products</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Products_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProductResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingProductResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingProductResource> GetAllAsync(BillingProductCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingProductCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingProductProductsRestClient.CreateListByBillingAccountRequest(Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingProductProductsRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingProductResource(Client, BillingProductData.DeserializeBillingProductData(e)), _billingProductProductsClientDiagnostics, Pipeline, "BillingProductCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the products for a billing account. These don't include products billed based on usage. The operation is supported for billing accounts with agreement type Microsoft Customer Agreement or Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/products</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Products_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProductResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingProductResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingProductResource> GetAll(BillingProductCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingProductCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingProductProductsRestClient.CreateListByBillingAccountRequest(Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingProductProductsRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingProductResource(Client, BillingProductData.DeserializeBillingProductData(e)), _billingProductProductsClientDiagnostics, Pipeline, "BillingProductCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/products/{productName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Products_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProductResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productName"> The ID that uniquely identifies a product. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string productName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productName, nameof(productName));

            using var scope = _billingProductProductsClientDiagnostics.CreateScope("BillingProductCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingProductProductsRestClient.GetAsync(Id.Name, productName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/products/{productName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Products_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProductResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productName"> The ID that uniquely identifies a product. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productName"/> is null. </exception>
        public virtual Response<bool> Exists(string productName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productName, nameof(productName));

            using var scope = _billingProductProductsClientDiagnostics.CreateScope("BillingProductCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingProductProductsRestClient.Get(Id.Name, productName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/products/{productName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Products_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProductResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productName"> The ID that uniquely identifies a product. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingProductResource>> GetIfExistsAsync(string productName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productName, nameof(productName));

            using var scope = _billingProductProductsClientDiagnostics.CreateScope("BillingProductCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingProductProductsRestClient.GetAsync(Id.Name, productName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingProductResource>(response.GetRawResponse());
                return Response.FromValue(new BillingProductResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/products/{productName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Products_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProductResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productName"> The ID that uniquely identifies a product. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productName"/> is null. </exception>
        public virtual NullableResponse<BillingProductResource> GetIfExists(string productName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productName, nameof(productName));

            using var scope = _billingProductProductsClientDiagnostics.CreateScope("BillingProductCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingProductProductsRestClient.Get(Id.Name, productName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingProductResource>(response.GetRawResponse());
                return Response.FromValue(new BillingProductResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingProductResource> IEnumerable<BillingProductResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<BillingProductResource> IAsyncEnumerable<BillingProductResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
