// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingInvoiceSectionResource"/> and their operations.
    /// Each <see cref="BillingInvoiceSectionResource"/> in the collection will belong to the same instance of <see cref="BillingProfileResource"/>.
    /// To get a <see cref="BillingInvoiceSectionCollection"/> instance call the GetBillingInvoiceSections method from an instance of <see cref="BillingProfileResource"/>.
    /// </summary>
    public partial class BillingInvoiceSectionCollection : ArmCollection, IEnumerable<BillingInvoiceSectionResource>, IAsyncEnumerable<BillingInvoiceSectionResource>
    {
        private readonly ClientDiagnostics _billingInvoiceSectionInvoiceSectionsClientDiagnostics;
        private readonly InvoiceSectionsRestOperations _billingInvoiceSectionInvoiceSectionsRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingInvoiceSectionCollection"/> class for mocking. </summary>
        protected BillingInvoiceSectionCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingInvoiceSectionCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingInvoiceSectionCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingInvoiceSectionInvoiceSectionsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingInvoiceSectionResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingInvoiceSectionResource.ResourceType, out string billingInvoiceSectionInvoiceSectionsApiVersion);
            _billingInvoiceSectionInvoiceSectionsRestClient = new InvoiceSectionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingInvoiceSectionInvoiceSectionsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingProfileResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingProfileResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates an invoice section. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InvoiceSections_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceSectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="invoiceSectionName"> The ID that uniquely identifies an invoice section. </param>
        /// <param name="data"> An invoice section. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceSectionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceSectionName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<BillingInvoiceSectionResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string invoiceSectionName, BillingInvoiceSectionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceSectionName, nameof(invoiceSectionName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _billingInvoiceSectionInvoiceSectionsClientDiagnostics.CreateScope("BillingInvoiceSectionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _billingInvoiceSectionInvoiceSectionsRestClient.CreateOrUpdateAsync(Id.Parent.Name, Id.Name, invoiceSectionName, data, cancellationToken).ConfigureAwait(false);
                var operation = new BillingArmOperation<BillingInvoiceSectionResource>(new BillingInvoiceSectionOperationSource(Client), _billingInvoiceSectionInvoiceSectionsClientDiagnostics, Pipeline, _billingInvoiceSectionInvoiceSectionsRestClient.CreateCreateOrUpdateRequest(Id.Parent.Name, Id.Name, invoiceSectionName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates an invoice section. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InvoiceSections_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceSectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="invoiceSectionName"> The ID that uniquely identifies an invoice section. </param>
        /// <param name="data"> An invoice section. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceSectionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceSectionName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<BillingInvoiceSectionResource> CreateOrUpdate(WaitUntil waitUntil, string invoiceSectionName, BillingInvoiceSectionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceSectionName, nameof(invoiceSectionName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _billingInvoiceSectionInvoiceSectionsClientDiagnostics.CreateScope("BillingInvoiceSectionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _billingInvoiceSectionInvoiceSectionsRestClient.CreateOrUpdate(Id.Parent.Name, Id.Name, invoiceSectionName, data, cancellationToken);
                var operation = new BillingArmOperation<BillingInvoiceSectionResource>(new BillingInvoiceSectionOperationSource(Client), _billingInvoiceSectionInvoiceSectionsClientDiagnostics, Pipeline, _billingInvoiceSectionInvoiceSectionsRestClient.CreateCreateOrUpdateRequest(Id.Parent.Name, Id.Name, invoiceSectionName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an invoice section by its ID. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InvoiceSections_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceSectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceSectionName"> The ID that uniquely identifies an invoice section. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceSectionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceSectionName"/> is null. </exception>
        public virtual async Task<Response<BillingInvoiceSectionResource>> GetAsync(string invoiceSectionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceSectionName, nameof(invoiceSectionName));

            using var scope = _billingInvoiceSectionInvoiceSectionsClientDiagnostics.CreateScope("BillingInvoiceSectionCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingInvoiceSectionInvoiceSectionsRestClient.GetAsync(Id.Parent.Name, Id.Name, invoiceSectionName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingInvoiceSectionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an invoice section by its ID. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InvoiceSections_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceSectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceSectionName"> The ID that uniquely identifies an invoice section. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceSectionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceSectionName"/> is null. </exception>
        public virtual Response<BillingInvoiceSectionResource> Get(string invoiceSectionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceSectionName, nameof(invoiceSectionName));

            using var scope = _billingInvoiceSectionInvoiceSectionsClientDiagnostics.CreateScope("BillingInvoiceSectionCollection.Get");
            scope.Start();
            try
            {
                var response = _billingInvoiceSectionInvoiceSectionsRestClient.Get(Id.Parent.Name, Id.Name, invoiceSectionName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingInvoiceSectionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the invoice sections that a user has access to. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InvoiceSections_ListByBillingProfile</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceSectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingInvoiceSectionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingInvoiceSectionResource> GetAllAsync(BillingInvoiceSectionCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingInvoiceSectionCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingInvoiceSectionInvoiceSectionsRestClient.CreateListByBillingProfileRequest(Id.Parent.Name, Id.Name, options.IncludeDeleted, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingInvoiceSectionInvoiceSectionsRestClient.CreateListByBillingProfileNextPageRequest(nextLink, Id.Parent.Name, Id.Name, options.IncludeDeleted, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingInvoiceSectionResource(Client, BillingInvoiceSectionData.DeserializeBillingInvoiceSectionData(e)), _billingInvoiceSectionInvoiceSectionsClientDiagnostics, Pipeline, "BillingInvoiceSectionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the invoice sections that a user has access to. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InvoiceSections_ListByBillingProfile</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceSectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingInvoiceSectionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingInvoiceSectionResource> GetAll(BillingInvoiceSectionCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingInvoiceSectionCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingInvoiceSectionInvoiceSectionsRestClient.CreateListByBillingProfileRequest(Id.Parent.Name, Id.Name, options.IncludeDeleted, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingInvoiceSectionInvoiceSectionsRestClient.CreateListByBillingProfileNextPageRequest(nextLink, Id.Parent.Name, Id.Name, options.IncludeDeleted, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingInvoiceSectionResource(Client, BillingInvoiceSectionData.DeserializeBillingInvoiceSectionData(e)), _billingInvoiceSectionInvoiceSectionsClientDiagnostics, Pipeline, "BillingInvoiceSectionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InvoiceSections_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceSectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceSectionName"> The ID that uniquely identifies an invoice section. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceSectionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceSectionName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string invoiceSectionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceSectionName, nameof(invoiceSectionName));

            using var scope = _billingInvoiceSectionInvoiceSectionsClientDiagnostics.CreateScope("BillingInvoiceSectionCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingInvoiceSectionInvoiceSectionsRestClient.GetAsync(Id.Parent.Name, Id.Name, invoiceSectionName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InvoiceSections_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceSectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceSectionName"> The ID that uniquely identifies an invoice section. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceSectionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceSectionName"/> is null. </exception>
        public virtual Response<bool> Exists(string invoiceSectionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceSectionName, nameof(invoiceSectionName));

            using var scope = _billingInvoiceSectionInvoiceSectionsClientDiagnostics.CreateScope("BillingInvoiceSectionCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingInvoiceSectionInvoiceSectionsRestClient.Get(Id.Parent.Name, Id.Name, invoiceSectionName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InvoiceSections_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceSectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceSectionName"> The ID that uniquely identifies an invoice section. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceSectionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceSectionName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingInvoiceSectionResource>> GetIfExistsAsync(string invoiceSectionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceSectionName, nameof(invoiceSectionName));

            using var scope = _billingInvoiceSectionInvoiceSectionsClientDiagnostics.CreateScope("BillingInvoiceSectionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingInvoiceSectionInvoiceSectionsRestClient.GetAsync(Id.Parent.Name, Id.Name, invoiceSectionName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingInvoiceSectionResource>(response.GetRawResponse());
                return Response.FromValue(new BillingInvoiceSectionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InvoiceSections_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceSectionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceSectionName"> The ID that uniquely identifies an invoice section. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceSectionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceSectionName"/> is null. </exception>
        public virtual NullableResponse<BillingInvoiceSectionResource> GetIfExists(string invoiceSectionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceSectionName, nameof(invoiceSectionName));

            using var scope = _billingInvoiceSectionInvoiceSectionsClientDiagnostics.CreateScope("BillingInvoiceSectionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingInvoiceSectionInvoiceSectionsRestClient.Get(Id.Parent.Name, Id.Name, invoiceSectionName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingInvoiceSectionResource>(response.GetRawResponse());
                return Response.FromValue(new BillingInvoiceSectionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingInvoiceSectionResource> IEnumerable<BillingInvoiceSectionResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<BillingInvoiceSectionResource> IAsyncEnumerable<BillingInvoiceSectionResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
