// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingInvoiceResource"/> and their operations.
    /// Each <see cref="BillingInvoiceResource"/> in the collection will belong to the same instance of <see cref="BillingAccountResource"/>.
    /// To get a <see cref="BillingInvoiceCollection"/> instance call the GetBillingInvoices method from an instance of <see cref="BillingAccountResource"/>.
    /// </summary>
    public partial class BillingInvoiceCollection : ArmCollection, IEnumerable<BillingInvoiceResource>, IAsyncEnumerable<BillingInvoiceResource>
    {
        private readonly ClientDiagnostics _billingInvoiceInvoicesClientDiagnostics;
        private readonly InvoicesRestOperations _billingInvoiceInvoicesRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingInvoiceCollection"/> class for mocking. </summary>
        protected BillingInvoiceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingInvoiceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingInvoiceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingInvoiceInvoicesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingInvoiceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingInvoiceResource.ResourceType, out string billingInvoiceInvoicesApiVersion);
            _billingInvoiceInvoicesRestClient = new InvoicesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingInvoiceInvoicesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an invoice by billing account name and ID. The operation is supported for all billing account types.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual async Task<Response<BillingInvoiceResource>> GetAsync(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _billingInvoiceInvoicesClientDiagnostics.CreateScope("BillingInvoiceCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingInvoiceInvoicesRestClient.GetByBillingAccountAsync(Id.Name, invoiceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an invoice by billing account name and ID. The operation is supported for all billing account types.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual Response<BillingInvoiceResource> Get(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _billingInvoiceInvoicesClientDiagnostics.CreateScope("BillingInvoiceCollection.Get");
            scope.Start();
            try
            {
                var response = _billingInvoiceInvoicesRestClient.GetByBillingAccount(Id.Name, invoiceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the invoices for a billing account for a given start date and end date. The operation is supported for all billing account types.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingInvoiceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingInvoiceResource> GetAllAsync(BillingInvoiceCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingInvoiceCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingInvoiceInvoicesRestClient.CreateListByBillingAccountRequest(Id.Name, options.PeriodStartDate, options.PeriodEndDate, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingInvoiceInvoicesRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, options.PeriodStartDate, options.PeriodEndDate, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingInvoiceResource(Client, BillingInvoiceData.DeserializeBillingInvoiceData(e)), _billingInvoiceInvoicesClientDiagnostics, Pipeline, "BillingInvoiceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the invoices for a billing account for a given start date and end date. The operation is supported for all billing account types.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingInvoiceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingInvoiceResource> GetAll(BillingInvoiceCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingInvoiceCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingInvoiceInvoicesRestClient.CreateListByBillingAccountRequest(Id.Name, options.PeriodStartDate, options.PeriodEndDate, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingInvoiceInvoicesRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, options.PeriodStartDate, options.PeriodEndDate, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingInvoiceResource(Client, BillingInvoiceData.DeserializeBillingInvoiceData(e)), _billingInvoiceInvoicesClientDiagnostics, Pipeline, "BillingInvoiceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _billingInvoiceInvoicesClientDiagnostics.CreateScope("BillingInvoiceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingInvoiceInvoicesRestClient.GetByBillingAccountAsync(Id.Name, invoiceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual Response<bool> Exists(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _billingInvoiceInvoicesClientDiagnostics.CreateScope("BillingInvoiceCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingInvoiceInvoicesRestClient.GetByBillingAccount(Id.Name, invoiceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingInvoiceResource>> GetIfExistsAsync(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _billingInvoiceInvoicesClientDiagnostics.CreateScope("BillingInvoiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingInvoiceInvoicesRestClient.GetByBillingAccountAsync(Id.Name, invoiceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingInvoiceResource>(response.GetRawResponse());
                return Response.FromValue(new BillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual NullableResponse<BillingInvoiceResource> GetIfExists(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _billingInvoiceInvoicesClientDiagnostics.CreateScope("BillingInvoiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingInvoiceInvoicesRestClient.GetByBillingAccount(Id.Name, invoiceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingInvoiceResource>(response.GetRawResponse());
                return Response.FromValue(new BillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingInvoiceResource> IEnumerable<BillingInvoiceResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<BillingInvoiceResource> IAsyncEnumerable<BillingInvoiceResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
