// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingEnrollmentAccountRoleDefinitionResource"/> and their operations.
    /// Each <see cref="BillingEnrollmentAccountRoleDefinitionResource"/> in the collection will belong to the same instance of <see cref="BillingEnrollmentAccountResource"/>.
    /// To get a <see cref="BillingEnrollmentAccountRoleDefinitionCollection"/> instance call the GetBillingEnrollmentAccountRoleDefinitions method from an instance of <see cref="BillingEnrollmentAccountResource"/>.
    /// </summary>
    public partial class BillingEnrollmentAccountRoleDefinitionCollection : ArmCollection, IEnumerable<BillingEnrollmentAccountRoleDefinitionResource>, IAsyncEnumerable<BillingEnrollmentAccountRoleDefinitionResource>
    {
        private readonly ClientDiagnostics _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionClientDiagnostics;
        private readonly BillingRoleDefinitionRestOperations _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingEnrollmentAccountRoleDefinitionCollection"/> class for mocking. </summary>
        protected BillingEnrollmentAccountRoleDefinitionCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingEnrollmentAccountRoleDefinitionCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingEnrollmentAccountRoleDefinitionCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingEnrollmentAccountRoleDefinitionResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingEnrollmentAccountRoleDefinitionResource.ResourceType, out string billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionApiVersion);
            _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient = new BillingRoleDefinitionRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingEnrollmentAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingEnrollmentAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the definition for a role on an enrollment account. The operation is supported for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleDefinitions/{roleDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleDefinition_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="roleDefinitionName"> The ID that uniquely identifies a role definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="roleDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="roleDefinitionName"/> is null. </exception>
        public virtual async Task<Response<BillingEnrollmentAccountRoleDefinitionResource>> GetAsync(string roleDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(roleDefinitionName, nameof(roleDefinitionName));

            using var scope = _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleDefinitionCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient.GetByEnrollmentAccountAsync(Id.Parent.Name, Id.Name, roleDefinitionName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountRoleDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the definition for a role on an enrollment account. The operation is supported for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleDefinitions/{roleDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleDefinition_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="roleDefinitionName"> The ID that uniquely identifies a role definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="roleDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="roleDefinitionName"/> is null. </exception>
        public virtual Response<BillingEnrollmentAccountRoleDefinitionResource> Get(string roleDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(roleDefinitionName, nameof(roleDefinitionName));

            using var scope = _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleDefinitionCollection.Get");
            scope.Start();
            try
            {
                var response = _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient.GetByEnrollmentAccount(Id.Parent.Name, Id.Name, roleDefinitionName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountRoleDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List the definition for an enrollment account. The operation is supported for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleDefinitions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleDefinition_ListByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingEnrollmentAccountRoleDefinitionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingEnrollmentAccountRoleDefinitionResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient.CreateListByEnrollmentAccountRequest(Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient.CreateListByEnrollmentAccountNextPageRequest(nextLink, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingEnrollmentAccountRoleDefinitionResource(Client, BillingRoleDefinitionData.DeserializeBillingRoleDefinitionData(e)), _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionClientDiagnostics, Pipeline, "BillingEnrollmentAccountRoleDefinitionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List the definition for an enrollment account. The operation is supported for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleDefinitions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleDefinition_ListByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingEnrollmentAccountRoleDefinitionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingEnrollmentAccountRoleDefinitionResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient.CreateListByEnrollmentAccountRequest(Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient.CreateListByEnrollmentAccountNextPageRequest(nextLink, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingEnrollmentAccountRoleDefinitionResource(Client, BillingRoleDefinitionData.DeserializeBillingRoleDefinitionData(e)), _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionClientDiagnostics, Pipeline, "BillingEnrollmentAccountRoleDefinitionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleDefinitions/{roleDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleDefinition_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="roleDefinitionName"> The ID that uniquely identifies a role definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="roleDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="roleDefinitionName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string roleDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(roleDefinitionName, nameof(roleDefinitionName));

            using var scope = _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleDefinitionCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient.GetByEnrollmentAccountAsync(Id.Parent.Name, Id.Name, roleDefinitionName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleDefinitions/{roleDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleDefinition_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="roleDefinitionName"> The ID that uniquely identifies a role definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="roleDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="roleDefinitionName"/> is null. </exception>
        public virtual Response<bool> Exists(string roleDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(roleDefinitionName, nameof(roleDefinitionName));

            using var scope = _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleDefinitionCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient.GetByEnrollmentAccount(Id.Parent.Name, Id.Name, roleDefinitionName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleDefinitions/{roleDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleDefinition_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="roleDefinitionName"> The ID that uniquely identifies a role definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="roleDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="roleDefinitionName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingEnrollmentAccountRoleDefinitionResource>> GetIfExistsAsync(string roleDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(roleDefinitionName, nameof(roleDefinitionName));

            using var scope = _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleDefinitionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient.GetByEnrollmentAccountAsync(Id.Parent.Name, Id.Name, roleDefinitionName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingEnrollmentAccountRoleDefinitionResource>(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountRoleDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleDefinitions/{roleDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleDefinition_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="roleDefinitionName"> The ID that uniquely identifies a role definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="roleDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="roleDefinitionName"/> is null. </exception>
        public virtual NullableResponse<BillingEnrollmentAccountRoleDefinitionResource> GetIfExists(string roleDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(roleDefinitionName, nameof(roleDefinitionName));

            using var scope = _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleDefinitionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingEnrollmentAccountRoleDefinitionBillingRoleDefinitionRestClient.GetByEnrollmentAccount(Id.Parent.Name, Id.Name, roleDefinitionName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingEnrollmentAccountRoleDefinitionResource>(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountRoleDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingEnrollmentAccountRoleDefinitionResource> IEnumerable<BillingEnrollmentAccountRoleDefinitionResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<BillingEnrollmentAccountRoleDefinitionResource> IAsyncEnumerable<BillingEnrollmentAccountRoleDefinitionResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
