// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingEnrollmentAccountRoleAssignmentResource"/> and their operations.
    /// Each <see cref="BillingEnrollmentAccountRoleAssignmentResource"/> in the collection will belong to the same instance of <see cref="BillingEnrollmentAccountResource"/>.
    /// To get a <see cref="BillingEnrollmentAccountRoleAssignmentCollection"/> instance call the GetBillingEnrollmentAccountRoleAssignments method from an instance of <see cref="BillingEnrollmentAccountResource"/>.
    /// </summary>
    public partial class BillingEnrollmentAccountRoleAssignmentCollection : ArmCollection, IEnumerable<BillingEnrollmentAccountRoleAssignmentResource>, IAsyncEnumerable<BillingEnrollmentAccountRoleAssignmentResource>
    {
        private readonly ClientDiagnostics _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics;
        private readonly BillingRoleAssignmentsRestOperations _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingEnrollmentAccountRoleAssignmentCollection"/> class for mocking. </summary>
        protected BillingEnrollmentAccountRoleAssignmentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingEnrollmentAccountRoleAssignmentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingEnrollmentAccountRoleAssignmentCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingEnrollmentAccountRoleAssignmentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingEnrollmentAccountRoleAssignmentResource.ResourceType, out string billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsApiVersion);
            _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient = new BillingRoleAssignmentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingEnrollmentAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingEnrollmentAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create or update a billing role assignment. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments/{billingRoleAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleAssignments_CreateOrUpdateByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="billingRoleAssignmentName"> The ID that uniquely identifies a role assignment. </param>
        /// <param name="data"> The properties of the billing role assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRoleAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRoleAssignmentName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<BillingEnrollmentAccountRoleAssignmentResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string billingRoleAssignmentName, BillingRoleAssignmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRoleAssignmentName, nameof(billingRoleAssignmentName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleAssignmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.CreateOrUpdateByEnrollmentAccountAsync(Id.Parent.Name, Id.Name, billingRoleAssignmentName, data, cancellationToken).ConfigureAwait(false);
                var operation = new BillingArmOperation<BillingEnrollmentAccountRoleAssignmentResource>(new BillingEnrollmentAccountRoleAssignmentOperationSource(Client), _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics, Pipeline, _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.CreateCreateOrUpdateByEnrollmentAccountRequest(Id.Parent.Name, Id.Name, billingRoleAssignmentName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update a billing role assignment. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments/{billingRoleAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleAssignments_CreateOrUpdateByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="billingRoleAssignmentName"> The ID that uniquely identifies a role assignment. </param>
        /// <param name="data"> The properties of the billing role assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRoleAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRoleAssignmentName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<BillingEnrollmentAccountRoleAssignmentResource> CreateOrUpdate(WaitUntil waitUntil, string billingRoleAssignmentName, BillingRoleAssignmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRoleAssignmentName, nameof(billingRoleAssignmentName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleAssignmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.CreateOrUpdateByEnrollmentAccount(Id.Parent.Name, Id.Name, billingRoleAssignmentName, data, cancellationToken);
                var operation = new BillingArmOperation<BillingEnrollmentAccountRoleAssignmentResource>(new BillingEnrollmentAccountRoleAssignmentOperationSource(Client), _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics, Pipeline, _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.CreateCreateOrUpdateByEnrollmentAccountRequest(Id.Parent.Name, Id.Name, billingRoleAssignmentName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a role assignment for the caller on a enrollment Account. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments/{billingRoleAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleAssignments_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRoleAssignmentName"> The ID that uniquely identifies a role assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRoleAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRoleAssignmentName"/> is null. </exception>
        public virtual async Task<Response<BillingEnrollmentAccountRoleAssignmentResource>> GetAsync(string billingRoleAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRoleAssignmentName, nameof(billingRoleAssignmentName));

            using var scope = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleAssignmentCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.GetByEnrollmentAccountAsync(Id.Parent.Name, Id.Name, billingRoleAssignmentName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountRoleAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a role assignment for the caller on a enrollment Account. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments/{billingRoleAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleAssignments_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRoleAssignmentName"> The ID that uniquely identifies a role assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRoleAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRoleAssignmentName"/> is null. </exception>
        public virtual Response<BillingEnrollmentAccountRoleAssignmentResource> Get(string billingRoleAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRoleAssignmentName, nameof(billingRoleAssignmentName));

            using var scope = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleAssignmentCollection.Get");
            scope.Start();
            try
            {
                var response = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.GetByEnrollmentAccount(Id.Parent.Name, Id.Name, billingRoleAssignmentName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountRoleAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the role assignments for the caller on a enrollment account. The operation is supported for billing accounts of type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleAssignments_ListByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingEnrollmentAccountRoleAssignmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingEnrollmentAccountRoleAssignmentResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.CreateListByEnrollmentAccountRequest(Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.CreateListByEnrollmentAccountNextPageRequest(nextLink, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingEnrollmentAccountRoleAssignmentResource(Client, BillingRoleAssignmentData.DeserializeBillingRoleAssignmentData(e)), _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics, Pipeline, "BillingEnrollmentAccountRoleAssignmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the role assignments for the caller on a enrollment account. The operation is supported for billing accounts of type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleAssignments_ListByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingEnrollmentAccountRoleAssignmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingEnrollmentAccountRoleAssignmentResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.CreateListByEnrollmentAccountRequest(Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.CreateListByEnrollmentAccountNextPageRequest(nextLink, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingEnrollmentAccountRoleAssignmentResource(Client, BillingRoleAssignmentData.DeserializeBillingRoleAssignmentData(e)), _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics, Pipeline, "BillingEnrollmentAccountRoleAssignmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments/{billingRoleAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleAssignments_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRoleAssignmentName"> The ID that uniquely identifies a role assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRoleAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRoleAssignmentName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string billingRoleAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRoleAssignmentName, nameof(billingRoleAssignmentName));

            using var scope = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleAssignmentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.GetByEnrollmentAccountAsync(Id.Parent.Name, Id.Name, billingRoleAssignmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments/{billingRoleAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleAssignments_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRoleAssignmentName"> The ID that uniquely identifies a role assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRoleAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRoleAssignmentName"/> is null. </exception>
        public virtual Response<bool> Exists(string billingRoleAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRoleAssignmentName, nameof(billingRoleAssignmentName));

            using var scope = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleAssignmentCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.GetByEnrollmentAccount(Id.Parent.Name, Id.Name, billingRoleAssignmentName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments/{billingRoleAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleAssignments_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRoleAssignmentName"> The ID that uniquely identifies a role assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRoleAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRoleAssignmentName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingEnrollmentAccountRoleAssignmentResource>> GetIfExistsAsync(string billingRoleAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRoleAssignmentName, nameof(billingRoleAssignmentName));

            using var scope = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleAssignmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.GetByEnrollmentAccountAsync(Id.Parent.Name, Id.Name, billingRoleAssignmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingEnrollmentAccountRoleAssignmentResource>(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountRoleAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments/{billingRoleAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingRoleAssignments_GetByEnrollmentAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountRoleAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingRoleAssignmentName"> The ID that uniquely identifies a role assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingRoleAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingRoleAssignmentName"/> is null. </exception>
        public virtual NullableResponse<BillingEnrollmentAccountRoleAssignmentResource> GetIfExists(string billingRoleAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingRoleAssignmentName, nameof(billingRoleAssignmentName));

            using var scope = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsClientDiagnostics.CreateScope("BillingEnrollmentAccountRoleAssignmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingEnrollmentAccountRoleAssignmentBillingRoleAssignmentsRestClient.GetByEnrollmentAccount(Id.Parent.Name, Id.Name, billingRoleAssignmentName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingEnrollmentAccountRoleAssignmentResource>(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountRoleAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingEnrollmentAccountRoleAssignmentResource> IEnumerable<BillingEnrollmentAccountRoleAssignmentResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<BillingEnrollmentAccountRoleAssignmentResource> IAsyncEnumerable<BillingEnrollmentAccountRoleAssignmentResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
