// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingEnrollmentAccountResource"/> and their operations.
    /// Each <see cref="BillingEnrollmentAccountResource"/> in the collection will belong to the same instance of <see cref="BillingAccountResource"/>.
    /// To get a <see cref="BillingEnrollmentAccountCollection"/> instance call the GetBillingEnrollmentAccounts method from an instance of <see cref="BillingAccountResource"/>.
    /// </summary>
    public partial class BillingEnrollmentAccountCollection : ArmCollection, IEnumerable<BillingEnrollmentAccountResource>, IAsyncEnumerable<BillingEnrollmentAccountResource>
    {
        private readonly ClientDiagnostics _billingEnrollmentAccountEnrollmentAccountsClientDiagnostics;
        private readonly EnrollmentAccountsRestOperations _billingEnrollmentAccountEnrollmentAccountsRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingEnrollmentAccountCollection"/> class for mocking. </summary>
        protected BillingEnrollmentAccountCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingEnrollmentAccountCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingEnrollmentAccountCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingEnrollmentAccountEnrollmentAccountsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingEnrollmentAccountResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingEnrollmentAccountResource.ResourceType, out string billingEnrollmentAccountEnrollmentAccountsApiVersion);
            _billingEnrollmentAccountEnrollmentAccountsRestClient = new EnrollmentAccountsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingEnrollmentAccountEnrollmentAccountsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an enrollment account by ID. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual async Task<Response<BillingEnrollmentAccountResource>> GetAsync(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingEnrollmentAccountCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingEnrollmentAccountEnrollmentAccountsRestClient.GetAsync(Id.Name, enrollmentAccountName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an enrollment account by ID. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual Response<BillingEnrollmentAccountResource> Get(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingEnrollmentAccountCollection.Get");
            scope.Start();
            try
            {
                var response = _billingEnrollmentAccountEnrollmentAccountsRestClient.Get(Id.Name, enrollmentAccountName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the enrollment accounts for a billing account. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingEnrollmentAccountResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingEnrollmentAccountResource> GetAllAsync(BillingEnrollmentAccountCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingEnrollmentAccountCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingEnrollmentAccountEnrollmentAccountsRestClient.CreateListByBillingAccountRequest(Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingEnrollmentAccountEnrollmentAccountsRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingEnrollmentAccountResource(Client, BillingEnrollmentAccountData.DeserializeBillingEnrollmentAccountData(e)), _billingEnrollmentAccountEnrollmentAccountsClientDiagnostics, Pipeline, "BillingEnrollmentAccountCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the enrollment accounts for a billing account. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingEnrollmentAccountResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingEnrollmentAccountResource> GetAll(BillingEnrollmentAccountCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingEnrollmentAccountCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingEnrollmentAccountEnrollmentAccountsRestClient.CreateListByBillingAccountRequest(Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingEnrollmentAccountEnrollmentAccountsRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingEnrollmentAccountResource(Client, BillingEnrollmentAccountData.DeserializeBillingEnrollmentAccountData(e)), _billingEnrollmentAccountEnrollmentAccountsClientDiagnostics, Pipeline, "BillingEnrollmentAccountCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingEnrollmentAccountCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingEnrollmentAccountEnrollmentAccountsRestClient.GetAsync(Id.Name, enrollmentAccountName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual Response<bool> Exists(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingEnrollmentAccountCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingEnrollmentAccountEnrollmentAccountsRestClient.Get(Id.Name, enrollmentAccountName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingEnrollmentAccountResource>> GetIfExistsAsync(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingEnrollmentAccountCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingEnrollmentAccountEnrollmentAccountsRestClient.GetAsync(Id.Name, enrollmentAccountName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingEnrollmentAccountResource>(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual NullableResponse<BillingEnrollmentAccountResource> GetIfExists(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingEnrollmentAccountCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingEnrollmentAccountEnrollmentAccountsRestClient.Get(Id.Name, enrollmentAccountName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingEnrollmentAccountResource>(response.GetRawResponse());
                return Response.FromValue(new BillingEnrollmentAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingEnrollmentAccountResource> IEnumerable<BillingEnrollmentAccountResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<BillingEnrollmentAccountResource> IAsyncEnumerable<BillingEnrollmentAccountResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
