// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingDepartmentEnrollmentAccountResource"/> and their operations.
    /// Each <see cref="BillingDepartmentEnrollmentAccountResource"/> in the collection will belong to the same instance of <see cref="BillingDepartmentResource"/>.
    /// To get a <see cref="BillingDepartmentEnrollmentAccountCollection"/> instance call the GetBillingDepartmentEnrollmentAccounts method from an instance of <see cref="BillingDepartmentResource"/>.
    /// </summary>
    public partial class BillingDepartmentEnrollmentAccountCollection : ArmCollection, IEnumerable<BillingDepartmentEnrollmentAccountResource>, IAsyncEnumerable<BillingDepartmentEnrollmentAccountResource>
    {
        private readonly ClientDiagnostics _billingDepartmentEnrollmentAccountEnrollmentAccountsClientDiagnostics;
        private readonly EnrollmentAccountsRestOperations _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingDepartmentEnrollmentAccountCollection"/> class for mocking. </summary>
        protected BillingDepartmentEnrollmentAccountCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingDepartmentEnrollmentAccountCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingDepartmentEnrollmentAccountCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingDepartmentEnrollmentAccountEnrollmentAccountsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingDepartmentEnrollmentAccountResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingDepartmentEnrollmentAccountResource.ResourceType, out string billingDepartmentEnrollmentAccountEnrollmentAccountsApiVersion);
            _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient = new EnrollmentAccountsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingDepartmentEnrollmentAccountEnrollmentAccountsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingDepartmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingDepartmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an enrollment account by department. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_GetByDepartment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual async Task<Response<BillingDepartmentEnrollmentAccountResource>> GetAsync(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingDepartmentEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingDepartmentEnrollmentAccountCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient.GetByDepartmentAsync(Id.Parent.Name, Id.Name, enrollmentAccountName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingDepartmentEnrollmentAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an enrollment account by department. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_GetByDepartment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual Response<BillingDepartmentEnrollmentAccountResource> Get(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingDepartmentEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingDepartmentEnrollmentAccountCollection.Get");
            scope.Start();
            try
            {
                var response = _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient.GetByDepartment(Id.Parent.Name, Id.Name, enrollmentAccountName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingDepartmentEnrollmentAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the enrollment accounts for a department. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}/enrollmentAccounts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_ListByDepartment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingDepartmentEnrollmentAccountResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingDepartmentEnrollmentAccountResource> GetAllAsync(BillingDepartmentEnrollmentAccountCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingDepartmentEnrollmentAccountCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient.CreateListByDepartmentRequest(Id.Parent.Name, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient.CreateListByDepartmentNextPageRequest(nextLink, Id.Parent.Name, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingDepartmentEnrollmentAccountResource(Client, BillingEnrollmentAccountData.DeserializeBillingEnrollmentAccountData(e)), _billingDepartmentEnrollmentAccountEnrollmentAccountsClientDiagnostics, Pipeline, "BillingDepartmentEnrollmentAccountCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the enrollment accounts for a department. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}/enrollmentAccounts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_ListByDepartment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingDepartmentEnrollmentAccountResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingDepartmentEnrollmentAccountResource> GetAll(BillingDepartmentEnrollmentAccountCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingDepartmentEnrollmentAccountCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient.CreateListByDepartmentRequest(Id.Parent.Name, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient.CreateListByDepartmentNextPageRequest(nextLink, Id.Parent.Name, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingDepartmentEnrollmentAccountResource(Client, BillingEnrollmentAccountData.DeserializeBillingEnrollmentAccountData(e)), _billingDepartmentEnrollmentAccountEnrollmentAccountsClientDiagnostics, Pipeline, "BillingDepartmentEnrollmentAccountCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_GetByDepartment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingDepartmentEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingDepartmentEnrollmentAccountCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient.GetByDepartmentAsync(Id.Parent.Name, Id.Name, enrollmentAccountName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_GetByDepartment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual Response<bool> Exists(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingDepartmentEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingDepartmentEnrollmentAccountCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient.GetByDepartment(Id.Parent.Name, Id.Name, enrollmentAccountName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_GetByDepartment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingDepartmentEnrollmentAccountResource>> GetIfExistsAsync(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingDepartmentEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingDepartmentEnrollmentAccountCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient.GetByDepartmentAsync(Id.Parent.Name, Id.Name, enrollmentAccountName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingDepartmentEnrollmentAccountResource>(response.GetRawResponse());
                return Response.FromValue(new BillingDepartmentEnrollmentAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}/enrollmentAccounts/{enrollmentAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EnrollmentAccounts_GetByDepartment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentEnrollmentAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="enrollmentAccountName"> The name of the enrollment account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="enrollmentAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="enrollmentAccountName"/> is null. </exception>
        public virtual NullableResponse<BillingDepartmentEnrollmentAccountResource> GetIfExists(string enrollmentAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(enrollmentAccountName, nameof(enrollmentAccountName));

            using var scope = _billingDepartmentEnrollmentAccountEnrollmentAccountsClientDiagnostics.CreateScope("BillingDepartmentEnrollmentAccountCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingDepartmentEnrollmentAccountEnrollmentAccountsRestClient.GetByDepartment(Id.Parent.Name, Id.Name, enrollmentAccountName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingDepartmentEnrollmentAccountResource>(response.GetRawResponse());
                return Response.FromValue(new BillingDepartmentEnrollmentAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingDepartmentEnrollmentAccountResource> IEnumerable<BillingDepartmentEnrollmentAccountResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<BillingDepartmentEnrollmentAccountResource> IAsyncEnumerable<BillingDepartmentEnrollmentAccountResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
