// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingDepartmentResource"/> and their operations.
    /// Each <see cref="BillingDepartmentResource"/> in the collection will belong to the same instance of <see cref="BillingAccountResource"/>.
    /// To get a <see cref="BillingDepartmentCollection"/> instance call the GetBillingDepartments method from an instance of <see cref="BillingAccountResource"/>.
    /// </summary>
    public partial class BillingDepartmentCollection : ArmCollection, IEnumerable<BillingDepartmentResource>, IAsyncEnumerable<BillingDepartmentResource>
    {
        private readonly ClientDiagnostics _billingDepartmentDepartmentsClientDiagnostics;
        private readonly DepartmentsRestOperations _billingDepartmentDepartmentsRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingDepartmentCollection"/> class for mocking. </summary>
        protected BillingDepartmentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingDepartmentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingDepartmentCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingDepartmentDepartmentsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingDepartmentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingDepartmentResource.ResourceType, out string billingDepartmentDepartmentsApiVersion);
            _billingDepartmentDepartmentsRestClient = new DepartmentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingDepartmentDepartmentsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a department by ID. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Departments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="departmentName"> The name of the department. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="departmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="departmentName"/> is null. </exception>
        public virtual async Task<Response<BillingDepartmentResource>> GetAsync(string departmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(departmentName, nameof(departmentName));

            using var scope = _billingDepartmentDepartmentsClientDiagnostics.CreateScope("BillingDepartmentCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingDepartmentDepartmentsRestClient.GetAsync(Id.Name, departmentName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingDepartmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a department by ID. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Departments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="departmentName"> The name of the department. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="departmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="departmentName"/> is null. </exception>
        public virtual Response<BillingDepartmentResource> Get(string departmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(departmentName, nameof(departmentName));

            using var scope = _billingDepartmentDepartmentsClientDiagnostics.CreateScope("BillingDepartmentCollection.Get");
            scope.Start();
            try
            {
                var response = _billingDepartmentDepartmentsRestClient.Get(Id.Name, departmentName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingDepartmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the departments that a user has access to. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Departments_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> The filter query option allows clients to filter a collection of resources that are addressed by a request URL. </param>
        /// <param name="orderBy"> The orderby query option allows clients to request resources in a particular order. </param>
        /// <param name="top"> The top query option requests the number of items in the queried collection to be included in the result. The maximum supported value for top is 50. </param>
        /// <param name="skip"> The skip query option requests the number of items in the queried collection that are to be skipped and not included in the result. </param>
        /// <param name="search"> The search query option allows clients to request items within a collection matching a free-text search expression. search is only supported for string fields. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingDepartmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingDepartmentResource> GetAllAsync(string filter = null, string orderBy = null, long? top = null, long? skip = null, string search = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingDepartmentDepartmentsRestClient.CreateListByBillingAccountRequest(Id.Name, filter, orderBy, top, skip, search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingDepartmentDepartmentsRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, filter, orderBy, top, skip, search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingDepartmentResource(Client, BillingDepartmentData.DeserializeBillingDepartmentData(e)), _billingDepartmentDepartmentsClientDiagnostics, Pipeline, "BillingDepartmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the departments that a user has access to. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Departments_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> The filter query option allows clients to filter a collection of resources that are addressed by a request URL. </param>
        /// <param name="orderBy"> The orderby query option allows clients to request resources in a particular order. </param>
        /// <param name="top"> The top query option requests the number of items in the queried collection to be included in the result. The maximum supported value for top is 50. </param>
        /// <param name="skip"> The skip query option requests the number of items in the queried collection that are to be skipped and not included in the result. </param>
        /// <param name="search"> The search query option allows clients to request items within a collection matching a free-text search expression. search is only supported for string fields. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingDepartmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingDepartmentResource> GetAll(string filter = null, string orderBy = null, long? top = null, long? skip = null, string search = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingDepartmentDepartmentsRestClient.CreateListByBillingAccountRequest(Id.Name, filter, orderBy, top, skip, search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingDepartmentDepartmentsRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, filter, orderBy, top, skip, search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingDepartmentResource(Client, BillingDepartmentData.DeserializeBillingDepartmentData(e)), _billingDepartmentDepartmentsClientDiagnostics, Pipeline, "BillingDepartmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Departments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="departmentName"> The name of the department. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="departmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="departmentName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string departmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(departmentName, nameof(departmentName));

            using var scope = _billingDepartmentDepartmentsClientDiagnostics.CreateScope("BillingDepartmentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingDepartmentDepartmentsRestClient.GetAsync(Id.Name, departmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Departments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="departmentName"> The name of the department. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="departmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="departmentName"/> is null. </exception>
        public virtual Response<bool> Exists(string departmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(departmentName, nameof(departmentName));

            using var scope = _billingDepartmentDepartmentsClientDiagnostics.CreateScope("BillingDepartmentCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingDepartmentDepartmentsRestClient.Get(Id.Name, departmentName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Departments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="departmentName"> The name of the department. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="departmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="departmentName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingDepartmentResource>> GetIfExistsAsync(string departmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(departmentName, nameof(departmentName));

            using var scope = _billingDepartmentDepartmentsClientDiagnostics.CreateScope("BillingDepartmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingDepartmentDepartmentsRestClient.GetAsync(Id.Name, departmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingDepartmentResource>(response.GetRawResponse());
                return Response.FromValue(new BillingDepartmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Departments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingDepartmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="departmentName"> The name of the department. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="departmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="departmentName"/> is null. </exception>
        public virtual NullableResponse<BillingDepartmentResource> GetIfExists(string departmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(departmentName, nameof(departmentName));

            using var scope = _billingDepartmentDepartmentsClientDiagnostics.CreateScope("BillingDepartmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingDepartmentDepartmentsRestClient.Get(Id.Name, departmentName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingDepartmentResource>(response.GetRawResponse());
                return Response.FromValue(new BillingDepartmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingDepartmentResource> IEnumerable<BillingDepartmentResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<BillingDepartmentResource> IAsyncEnumerable<BillingDepartmentResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
