// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A Class representing a BillingCustomer along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="BillingCustomerResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetBillingCustomerResource method.
    /// Otherwise you can get one from its parent resource <see cref="BillingAccountResource"/> using the GetBillingCustomer method.
    /// </summary>
    public partial class BillingCustomerResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="BillingCustomerResource"/> instance. </summary>
        /// <param name="billingAccountName"> The billingAccountName. </param>
        /// <param name="customerName"> The customerName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string billingAccountName, string customerName)
        {
            var resourceId = $"/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _billingCustomerCustomersClientDiagnostics;
        private readonly CustomersRestOperations _billingCustomerCustomersRestClient;
        private readonly ClientDiagnostics _billingPermissionsClientDiagnostics;
        private readonly BillingPermissionsRestOperations _billingPermissionsRestClient;
        private readonly ClientDiagnostics _billingSubscriptionsClientDiagnostics;
        private readonly BillingSubscriptionsRestOperations _billingSubscriptionsRestClient;
        private readonly ClientDiagnostics _billingProductProductsClientDiagnostics;
        private readonly ProductsRestOperations _billingProductProductsRestClient;
        private readonly BillingCustomerData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Billing/billingAccounts/customers";

        /// <summary> Initializes a new instance of the <see cref="BillingCustomerResource"/> class for mocking. </summary>
        protected BillingCustomerResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingCustomerResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal BillingCustomerResource(ArmClient client, BillingCustomerData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="BillingCustomerResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal BillingCustomerResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingCustomerCustomersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string billingCustomerCustomersApiVersion);
            _billingCustomerCustomersRestClient = new CustomersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingCustomerCustomersApiVersion);
            _billingPermissionsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _billingPermissionsRestClient = new BillingPermissionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _billingSubscriptionsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _billingSubscriptionsRestClient = new BillingSubscriptionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _billingProductProductsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingProductResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingProductResource.ResourceType, out string billingProductProductsApiVersion);
            _billingProductProductsRestClient = new ProductsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingProductProductsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual BillingCustomerData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets an object representing a BillingCustomerPolicyResource along with the instance operations that can be performed on it in the BillingCustomer. </summary>
        /// <returns> Returns a <see cref="BillingCustomerPolicyResource"/> object. </returns>
        public virtual BillingCustomerPolicyResource GetBillingCustomerPolicy()
        {
            return new BillingCustomerPolicyResource(Client, Id.AppendChildResource("policies", "default"));
        }

        /// <summary>
        /// Gets a customer by its ID at billing account level. The operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Customers_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingCustomerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<BillingCustomerResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _billingCustomerCustomersClientDiagnostics.CreateScope("BillingCustomerResource.Get");
            scope.Start();
            try
            {
                var response = await _billingCustomerCustomersRestClient.GetByBillingAccountAsync(Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingCustomerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a customer by its ID at billing account level. The operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Customers_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingCustomerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<BillingCustomerResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _billingCustomerCustomersClientDiagnostics.CreateScope("BillingCustomerResource.Get");
            scope.Start();
            try
            {
                var response = _billingCustomerCustomersRestClient.GetByBillingAccount(Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingCustomerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the billing permissions the caller has for a customer at billing account level.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}/billingPermissions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingPermissions_ListByCustomerAtBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingPermission"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingPermission> GetBillingPermissionsByCustomerAtBillingAccountAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingPermissionsRestClient.CreateListByCustomerAtBillingAccountRequest(Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingPermissionsRestClient.CreateListByCustomerAtBillingAccountNextPageRequest(nextLink, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BillingPermission.DeserializeBillingPermission(e), _billingPermissionsClientDiagnostics, Pipeline, "BillingCustomerResource.GetBillingPermissionsByCustomerAtBillingAccount", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the billing permissions the caller has for a customer at billing account level.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}/billingPermissions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingPermissions_ListByCustomerAtBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingPermission"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingPermission> GetBillingPermissionsByCustomerAtBillingAccount(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingPermissionsRestClient.CreateListByCustomerAtBillingAccountRequest(Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingPermissionsRestClient.CreateListByCustomerAtBillingAccountNextPageRequest(nextLink, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BillingPermission.DeserializeBillingPermission(e), _billingPermissionsClientDiagnostics, Pipeline, "BillingCustomerResource.GetBillingPermissionsByCustomerAtBillingAccount", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the subscriptions for a customer at billing account level. The operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}/billingSubscriptions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingSubscriptions_ListByCustomerAtBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingSubscriptionData"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingSubscriptionData> GetBillingSubscriptionsByCustomerAtBillingAccountAsync(BillingCustomerResourceGetBillingSubscriptionsByCustomerAtBillingAccountOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingCustomerResourceGetBillingSubscriptionsByCustomerAtBillingAccountOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingSubscriptionsRestClient.CreateListByCustomerAtBillingAccountRequest(Id.Parent.Name, Id.Name, options.IncludeDeleted, options.Expand, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingSubscriptionsRestClient.CreateListByCustomerAtBillingAccountNextPageRequest(nextLink, Id.Parent.Name, Id.Name, options.IncludeDeleted, options.Expand, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BillingSubscriptionData.DeserializeBillingSubscriptionData(e), _billingSubscriptionsClientDiagnostics, Pipeline, "BillingCustomerResource.GetBillingSubscriptionsByCustomerAtBillingAccount", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the subscriptions for a customer at billing account level. The operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}/billingSubscriptions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingSubscriptions_ListByCustomerAtBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingSubscriptionData"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingSubscriptionData> GetBillingSubscriptionsByCustomerAtBillingAccount(BillingCustomerResourceGetBillingSubscriptionsByCustomerAtBillingAccountOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingCustomerResourceGetBillingSubscriptionsByCustomerAtBillingAccountOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingSubscriptionsRestClient.CreateListByCustomerAtBillingAccountRequest(Id.Parent.Name, Id.Name, options.IncludeDeleted, options.Expand, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingSubscriptionsRestClient.CreateListByCustomerAtBillingAccountNextPageRequest(nextLink, Id.Parent.Name, Id.Name, options.IncludeDeleted, options.Expand, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BillingSubscriptionData.DeserializeBillingSubscriptionData(e), _billingSubscriptionsClientDiagnostics, Pipeline, "BillingCustomerResource.GetBillingSubscriptionsByCustomerAtBillingAccount", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the products for a customer. These don't include products billed based on usage.The operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}/products</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Products_ListByCustomer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProductResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingProductResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingProductResource> GetProductsAsync(BillingCustomerResourceGetProductsOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingCustomerResourceGetProductsOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingProductProductsRestClient.CreateListByCustomerRequest(Id.Parent.Name, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingProductProductsRestClient.CreateListByCustomerNextPageRequest(nextLink, Id.Parent.Name, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingProductResource(Client, BillingProductData.DeserializeBillingProductData(e)), _billingProductProductsClientDiagnostics, Pipeline, "BillingCustomerResource.GetProducts", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the products for a customer. These don't include products billed based on usage.The operation is supported only for billing accounts with agreement type Microsoft Partner Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}/products</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Products_ListByCustomer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingProductResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingProductResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingProductResource> GetProducts(BillingCustomerResourceGetProductsOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingCustomerResourceGetProductsOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingProductProductsRestClient.CreateListByCustomerRequest(Id.Parent.Name, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingProductProductsRestClient.CreateListByCustomerNextPageRequest(nextLink, Id.Parent.Name, Id.Name, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingProductResource(Client, BillingProductData.DeserializeBillingProductData(e)), _billingProductProductsClientDiagnostics, Pipeline, "BillingCustomerResource.GetProducts", "value", "nextLink", cancellationToken);
        }
    }
}
