// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="BillingAccountResource"/> and their operations.
    /// Each <see cref="BillingAccountResource"/> in the collection will belong to the same instance of <see cref="TenantResource"/>.
    /// To get a <see cref="BillingAccountCollection"/> instance call the GetBillingAccounts method from an instance of <see cref="TenantResource"/>.
    /// </summary>
    public partial class BillingAccountCollection : ArmCollection, IEnumerable<BillingAccountResource>, IAsyncEnumerable<BillingAccountResource>
    {
        private readonly ClientDiagnostics _billingAccountClientDiagnostics;
        private readonly BillingAccountsRestOperations _billingAccountRestClient;

        /// <summary> Initializes a new instance of the <see cref="BillingAccountCollection"/> class for mocking. </summary>
        protected BillingAccountCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BillingAccountCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal BillingAccountCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _billingAccountClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", BillingAccountResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BillingAccountResource.ResourceType, out string billingAccountApiVersion);
            _billingAccountRestClient = new BillingAccountsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, billingAccountApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != TenantResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, TenantResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a billing account by its ID.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingAccountName"> The ID that uniquely identifies a billing account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingAccountName"/> is null. </exception>
        public virtual async Task<Response<BillingAccountResource>> GetAsync(string billingAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingAccountName, nameof(billingAccountName));

            using var scope = _billingAccountClientDiagnostics.CreateScope("BillingAccountCollection.Get");
            scope.Start();
            try
            {
                var response = await _billingAccountRestClient.GetAsync(billingAccountName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a billing account by its ID.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingAccountName"> The ID that uniquely identifies a billing account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingAccountName"/> is null. </exception>
        public virtual Response<BillingAccountResource> Get(string billingAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingAccountName, nameof(billingAccountName));

            using var scope = _billingAccountClientDiagnostics.CreateScope("BillingAccountCollection.Get");
            scope.Start();
            try
            {
                var response = _billingAccountRestClient.Get(billingAccountName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BillingAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the billing accounts that a user has access to.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingAccounts_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BillingAccountResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BillingAccountResource> GetAllAsync(BillingAccountCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingAccountCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingAccountRestClient.CreateListRequest(options.IncludeAll, options.IncludeAllWithoutBillingProfiles, options.IncludeDeleted, options.IncludePendingAgreement, options.IncludeResellee, options.LegalOwnerTID, options.LegalOwnerOID, options.Filter, options.Expand, options.Top, options.Skip, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingAccountRestClient.CreateListNextPageRequest(nextLink, options.IncludeAll, options.IncludeAllWithoutBillingProfiles, options.IncludeDeleted, options.IncludePendingAgreement, options.IncludeResellee, options.LegalOwnerTID, options.LegalOwnerOID, options.Filter, options.Expand, options.Top, options.Skip, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BillingAccountResource(Client, BillingAccountData.DeserializeBillingAccountData(e)), _billingAccountClientDiagnostics, Pipeline, "BillingAccountCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the billing accounts that a user has access to.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingAccounts_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BillingAccountResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BillingAccountResource> GetAll(BillingAccountCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new BillingAccountCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _billingAccountRestClient.CreateListRequest(options.IncludeAll, options.IncludeAllWithoutBillingProfiles, options.IncludeDeleted, options.IncludePendingAgreement, options.IncludeResellee, options.LegalOwnerTID, options.LegalOwnerOID, options.Filter, options.Expand, options.Top, options.Skip, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _billingAccountRestClient.CreateListNextPageRequest(nextLink, options.IncludeAll, options.IncludeAllWithoutBillingProfiles, options.IncludeDeleted, options.IncludePendingAgreement, options.IncludeResellee, options.LegalOwnerTID, options.LegalOwnerOID, options.Filter, options.Expand, options.Top, options.Skip, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BillingAccountResource(Client, BillingAccountData.DeserializeBillingAccountData(e)), _billingAccountClientDiagnostics, Pipeline, "BillingAccountCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingAccountName"> The ID that uniquely identifies a billing account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingAccountName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string billingAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingAccountName, nameof(billingAccountName));

            using var scope = _billingAccountClientDiagnostics.CreateScope("BillingAccountCollection.Exists");
            scope.Start();
            try
            {
                var response = await _billingAccountRestClient.GetAsync(billingAccountName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingAccountName"> The ID that uniquely identifies a billing account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingAccountName"/> is null. </exception>
        public virtual Response<bool> Exists(string billingAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingAccountName, nameof(billingAccountName));

            using var scope = _billingAccountClientDiagnostics.CreateScope("BillingAccountCollection.Exists");
            scope.Start();
            try
            {
                var response = _billingAccountRestClient.Get(billingAccountName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingAccountName"> The ID that uniquely identifies a billing account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingAccountName"/> is null. </exception>
        public virtual async Task<NullableResponse<BillingAccountResource>> GetIfExistsAsync(string billingAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingAccountName, nameof(billingAccountName));

            using var scope = _billingAccountClientDiagnostics.CreateScope("BillingAccountCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _billingAccountRestClient.GetAsync(billingAccountName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BillingAccountResource>(response.GetRawResponse());
                return Response.FromValue(new BillingAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BillingAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingAccountName"> The ID that uniquely identifies a billing account. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingAccountName"/> is null. </exception>
        public virtual NullableResponse<BillingAccountResource> GetIfExists(string billingAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingAccountName, nameof(billingAccountName));

            using var scope = _billingAccountClientDiagnostics.CreateScope("BillingAccountCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _billingAccountRestClient.Get(billingAccountName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BillingAccountResource>(response.GetRawResponse());
                return Response.FromValue(new BillingAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BillingAccountResource> IEnumerable<BillingAccountResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<BillingAccountResource> IAsyncEnumerable<BillingAccountResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
