// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingTransferDetailResource
    {
        // TransferGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_TransferGet()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/transfersGet.json
            // this example is just showing the usage of "Transfers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingTransferDetailResource created on azure
            // for more information of creating BillingTransferDetailResource, please refer to the document of BillingTransferDetailResource
            string billingAccountName = "10000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string billingProfileName = "xxxx-xxxx-xxx-xxx";
            string invoiceSectionName = "yyyy-yyyy-yyy-yyy";
            string transferName = "aabb123";
            ResourceIdentifier billingTransferDetailResourceId = BillingTransferDetailResource.CreateResourceIdentifier(billingAccountName, billingProfileName, invoiceSectionName, transferName);
            BillingTransferDetailResource billingTransferDetail = client.GetBillingTransferDetailResource(billingTransferDetailResourceId);

            // invoke the operation
            BillingTransferDetailResource result = await billingTransferDetail.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingTransferDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // InitiateTransfer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_InitiateTransfer()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/transfersInitiate.json
            // this example is just showing the usage of "Transfers_Initiate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingTransferDetailResource created on azure
            // for more information of creating BillingTransferDetailResource, please refer to the document of BillingTransferDetailResource
            string billingAccountName = "10000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string billingProfileName = "xxxx-xxxx-xxx-xxx";
            string invoiceSectionName = "yyyy-yyyy-yyy-yyy";
            string transferName = "aabb123";
            ResourceIdentifier billingTransferDetailResourceId = BillingTransferDetailResource.CreateResourceIdentifier(billingAccountName, billingProfileName, invoiceSectionName, transferName);
            BillingTransferDetailResource billingTransferDetail = client.GetBillingTransferDetailResource(billingTransferDetailResourceId);

            // invoke the operation
            BillingTransferDetailCreateOrUpdateContent content = new BillingTransferDetailCreateOrUpdateContent()
            {
                RecipientEmailId = "user@contoso.com",
            };
            ArmOperation<BillingTransferDetailResource> lro = await billingTransferDetail.UpdateAsync(WaitUntil.Completed, content);
            BillingTransferDetailResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingTransferDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // TransferCancel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Cancel_TransferCancel()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/transfersCancel.json
            // this example is just showing the usage of "Transfers_Cancel" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingTransferDetailResource created on azure
            // for more information of creating BillingTransferDetailResource, please refer to the document of BillingTransferDetailResource
            string billingAccountName = "10000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string billingProfileName = "xxxx-xxxx-xxx-xxx";
            string invoiceSectionName = "yyyy-yyyy-yyy-yyy";
            string transferName = "aabb123";
            ResourceIdentifier billingTransferDetailResourceId = BillingTransferDetailResource.CreateResourceIdentifier(billingAccountName, billingProfileName, invoiceSectionName, transferName);
            BillingTransferDetailResource billingTransferDetail = client.GetBillingTransferDetailResource(billingTransferDetailResourceId);

            // invoke the operation
            BillingTransferDetailResource result = await billingTransferDetail.CancelAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingTransferDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
