// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingSavingsPlanModelCollection
    {
        // SavingsPlansInOrderList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_SavingsPlansInOrderList()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/savingsPlansListBySavingsPlanOrders.json
            // this example is just showing the usage of "SavingsPlans_ListBySavingsPlanOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SavingsPlanOrderModelResource created on azure
            // for more information of creating SavingsPlanOrderModelResource, please refer to the document of SavingsPlanOrderModelResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string savingsPlanOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier savingsPlanOrderModelResourceId = SavingsPlanOrderModelResource.CreateResourceIdentifier(billingAccountName, savingsPlanOrderId);
            SavingsPlanOrderModelResource savingsPlanOrderModel = client.GetSavingsPlanOrderModelResource(savingsPlanOrderModelResourceId);

            // get the collection of this BillingSavingsPlanModelResource
            BillingSavingsPlanModelCollection collection = savingsPlanOrderModel.GetBillingSavingsPlanModels();

            // invoke the operation and iterate over the result
            await foreach (BillingSavingsPlanModelResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingSavingsPlanModelData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // SavingsPlanGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SavingsPlanGet()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/savingsPlanGetByBillingAccount.json
            // this example is just showing the usage of "SavingsPlans_GetByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SavingsPlanOrderModelResource created on azure
            // for more information of creating SavingsPlanOrderModelResource, please refer to the document of SavingsPlanOrderModelResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string savingsPlanOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier savingsPlanOrderModelResourceId = SavingsPlanOrderModelResource.CreateResourceIdentifier(billingAccountName, savingsPlanOrderId);
            SavingsPlanOrderModelResource savingsPlanOrderModel = client.GetSavingsPlanOrderModelResource(savingsPlanOrderModelResourceId);

            // get the collection of this BillingSavingsPlanModelResource
            BillingSavingsPlanModelCollection collection = savingsPlanOrderModel.GetBillingSavingsPlanModels();

            // invoke the operation
            string savingsPlanId = "30000000-0000-0000-0000-000000000000";
            BillingSavingsPlanModelResource result = await collection.GetAsync(savingsPlanId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingSavingsPlanModelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SavingsPlanGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_SavingsPlanGet()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/savingsPlanGetByBillingAccount.json
            // this example is just showing the usage of "SavingsPlans_GetByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SavingsPlanOrderModelResource created on azure
            // for more information of creating SavingsPlanOrderModelResource, please refer to the document of SavingsPlanOrderModelResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string savingsPlanOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier savingsPlanOrderModelResourceId = SavingsPlanOrderModelResource.CreateResourceIdentifier(billingAccountName, savingsPlanOrderId);
            SavingsPlanOrderModelResource savingsPlanOrderModel = client.GetSavingsPlanOrderModelResource(savingsPlanOrderModelResourceId);

            // get the collection of this BillingSavingsPlanModelResource
            BillingSavingsPlanModelCollection collection = savingsPlanOrderModel.GetBillingSavingsPlanModels();

            // invoke the operation
            string savingsPlanId = "30000000-0000-0000-0000-000000000000";
            bool result = await collection.ExistsAsync(savingsPlanId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // SavingsPlanGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_SavingsPlanGet()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/savingsPlanGetByBillingAccount.json
            // this example is just showing the usage of "SavingsPlans_GetByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SavingsPlanOrderModelResource created on azure
            // for more information of creating SavingsPlanOrderModelResource, please refer to the document of SavingsPlanOrderModelResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string savingsPlanOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier savingsPlanOrderModelResourceId = SavingsPlanOrderModelResource.CreateResourceIdentifier(billingAccountName, savingsPlanOrderId);
            SavingsPlanOrderModelResource savingsPlanOrderModel = client.GetSavingsPlanOrderModelResource(savingsPlanOrderModelResourceId);

            // get the collection of this BillingSavingsPlanModelResource
            BillingSavingsPlanModelCollection collection = savingsPlanOrderModel.GetBillingSavingsPlanModels();

            // invoke the operation
            string savingsPlanId = "30000000-0000-0000-0000-000000000000";
            NullableResponse<BillingSavingsPlanModelResource> response = await collection.GetIfExistsAsync(savingsPlanId);
            BillingSavingsPlanModelResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingSavingsPlanModelData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // SavingsPlanGetExpandRenewProperties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SavingsPlanGetExpandRenewProperties()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/savingsPlanGetExpandRenewPropertiesByBillingAccount.json
            // this example is just showing the usage of "SavingsPlans_GetByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SavingsPlanOrderModelResource created on azure
            // for more information of creating SavingsPlanOrderModelResource, please refer to the document of SavingsPlanOrderModelResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string savingsPlanOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier savingsPlanOrderModelResourceId = SavingsPlanOrderModelResource.CreateResourceIdentifier(billingAccountName, savingsPlanOrderId);
            SavingsPlanOrderModelResource savingsPlanOrderModel = client.GetSavingsPlanOrderModelResource(savingsPlanOrderModelResourceId);

            // get the collection of this BillingSavingsPlanModelResource
            BillingSavingsPlanModelCollection collection = savingsPlanOrderModel.GetBillingSavingsPlanModels();

            // invoke the operation
            string savingsPlanId = "30000000-0000-0000-0000-000000000000";
            BillingSavingsPlanModelResource result = await collection.GetAsync(savingsPlanId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingSavingsPlanModelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SavingsPlanGetExpandRenewProperties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_SavingsPlanGetExpandRenewProperties()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/savingsPlanGetExpandRenewPropertiesByBillingAccount.json
            // this example is just showing the usage of "SavingsPlans_GetByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SavingsPlanOrderModelResource created on azure
            // for more information of creating SavingsPlanOrderModelResource, please refer to the document of SavingsPlanOrderModelResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string savingsPlanOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier savingsPlanOrderModelResourceId = SavingsPlanOrderModelResource.CreateResourceIdentifier(billingAccountName, savingsPlanOrderId);
            SavingsPlanOrderModelResource savingsPlanOrderModel = client.GetSavingsPlanOrderModelResource(savingsPlanOrderModelResourceId);

            // get the collection of this BillingSavingsPlanModelResource
            BillingSavingsPlanModelCollection collection = savingsPlanOrderModel.GetBillingSavingsPlanModels();

            // invoke the operation
            string savingsPlanId = "30000000-0000-0000-0000-000000000000";
            bool result = await collection.ExistsAsync(savingsPlanId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // SavingsPlanGetExpandRenewProperties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_SavingsPlanGetExpandRenewProperties()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/savingsPlanGetExpandRenewPropertiesByBillingAccount.json
            // this example is just showing the usage of "SavingsPlans_GetByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SavingsPlanOrderModelResource created on azure
            // for more information of creating SavingsPlanOrderModelResource, please refer to the document of SavingsPlanOrderModelResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string savingsPlanOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier savingsPlanOrderModelResourceId = SavingsPlanOrderModelResource.CreateResourceIdentifier(billingAccountName, savingsPlanOrderId);
            SavingsPlanOrderModelResource savingsPlanOrderModel = client.GetSavingsPlanOrderModelResource(savingsPlanOrderModelResourceId);

            // get the collection of this BillingSavingsPlanModelResource
            BillingSavingsPlanModelCollection collection = savingsPlanOrderModel.GetBillingSavingsPlanModels();

            // invoke the operation
            string savingsPlanId = "30000000-0000-0000-0000-000000000000";
            NullableResponse<BillingSavingsPlanModelResource> response = await collection.GetIfExistsAsync(savingsPlanId);
            BillingSavingsPlanModelResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingSavingsPlanModelData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
