// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingReservationCollection
    {
        // reservationGetByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ReservationGetByBillingAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccount.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            BillingReservationResource result = await collection.GetAsync(reservationId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingReservationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // reservationGetByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ReservationGetByBillingAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccount.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            bool result = await collection.ExistsAsync(reservationId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // reservationGetByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ReservationGetByBillingAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccount.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            NullableResponse<BillingReservationResource> response = await collection.GetIfExistsAsync(reservationId);
            BillingReservationResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingReservationData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // reservationGetByBillingAccountManagementGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ReservationGetByBillingAccountManagementGroup()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccountManagementGroup.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            BillingReservationResource result = await collection.GetAsync(reservationId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingReservationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // reservationGetByBillingAccountManagementGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ReservationGetByBillingAccountManagementGroup()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccountManagementGroup.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            bool result = await collection.ExistsAsync(reservationId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // reservationGetByBillingAccountManagementGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ReservationGetByBillingAccountManagementGroup()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccountManagementGroup.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            NullableResponse<BillingReservationResource> response = await collection.GetIfExistsAsync(reservationId);
            BillingReservationResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingReservationData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // reservationGetByBillingAccountSingleResourceGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ReservationGetByBillingAccountSingleResourceGroup()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccountSingleResourceGroup.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            BillingReservationResource result = await collection.GetAsync(reservationId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingReservationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // reservationGetByBillingAccountSingleResourceGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ReservationGetByBillingAccountSingleResourceGroup()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccountSingleResourceGroup.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            bool result = await collection.ExistsAsync(reservationId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // reservationGetByBillingAccountSingleResourceGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ReservationGetByBillingAccountSingleResourceGroup()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccountSingleResourceGroup.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            NullableResponse<BillingReservationResource> response = await collection.GetIfExistsAsync(reservationId);
            BillingReservationResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingReservationData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // reservationGetByBillingAccountSingleScope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ReservationGetByBillingAccountSingleScope()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccountSingleScope.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            BillingReservationResource result = await collection.GetAsync(reservationId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingReservationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // reservationGetByBillingAccountSingleScope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ReservationGetByBillingAccountSingleScope()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccountSingleScope.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            bool result = await collection.ExistsAsync(reservationId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // reservationGetByBillingAccountSingleScope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ReservationGetByBillingAccountSingleScope()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationGetByBillingAccountSingleScope.json
            // this example is just showing the usage of "Reservations_GetByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation
            string reservationId = "30000000-0000-0000-0000-000000000000";
            NullableResponse<BillingReservationResource> response = await collection.GetIfExistsAsync(reservationId);
            BillingReservationResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingReservationData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // reservationsGetFromOrderByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ReservationsGetFromOrderByBillingAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/reservationsGetFromOrderByBillingAccount.json
            // this example is just showing the usage of "Reservations_ListByReservationOrder" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingReservationOrderResource created on azure
            // for more information of creating BillingReservationOrderResource, please refer to the document of BillingReservationOrderResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string reservationOrderId = "20000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingReservationOrderResourceId = BillingReservationOrderResource.CreateResourceIdentifier(billingAccountName, reservationOrderId);
            BillingReservationOrderResource billingReservationOrder = client.GetBillingReservationOrderResource(billingReservationOrderResourceId);

            // get the collection of this BillingReservationResource
            BillingReservationCollection collection = billingReservationOrder.GetBillingReservations();

            // invoke the operation and iterate over the result
            await foreach (BillingReservationResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingReservationData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
