// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingProfileCustomerResource
    {
        // BillingPermissionsListByCustomer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetBillingPermissions_BillingPermissionsListByCustomer()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/billingPermissionsListByCustomer.json
            // this example is just showing the usage of "BillingPermissions_ListByCustomer" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProfileCustomerResource created on azure
            // for more information of creating BillingProfileCustomerResource, please refer to the document of BillingProfileCustomerResource
            string billingAccountName = "10000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string billingProfileName = "BKM6-54VH-BG7-PGB";
            string customerName = "11111111-1111-1111-1111-111111111111";
            ResourceIdentifier billingProfileCustomerResourceId = BillingProfileCustomerResource.CreateResourceIdentifier(billingAccountName, billingProfileName, customerName);
            BillingProfileCustomerResource billingProfileCustomer = client.GetBillingProfileCustomerResource(billingProfileCustomerResourceId);

            // invoke the operation and iterate over the result
            await foreach (BillingPermission item in billingProfileCustomer.GetBillingPermissionsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // CheckAccessByCustomer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckAccessBillingPermissions_CheckAccessByCustomer()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/checkAccessByCustomer.json
            // this example is just showing the usage of "BillingPermissions_CheckAccessByCustomer" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProfileCustomerResource created on azure
            // for more information of creating BillingProfileCustomerResource, please refer to the document of BillingProfileCustomerResource
            string billingAccountName = "10000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string billingProfileName = "xxxx-xxxx-xxx-xxx";
            string customerName = "703ab484-dda2-4402-827b-a74513b61e2d";
            ResourceIdentifier billingProfileCustomerResourceId = BillingProfileCustomerResource.CreateResourceIdentifier(billingAccountName, billingProfileName, customerName);
            BillingProfileCustomerResource billingProfileCustomer = client.GetBillingProfileCustomerResource(billingProfileCustomerResourceId);

            // invoke the operation and iterate over the result
            BillingCheckAccessContent content = new BillingCheckAccessContent()
            {
                Actions =
{
"Microsoft.Billing/billingAccounts/read","Microsoft.Subscription/subscriptions/write"
},
            };
            await foreach (BillingCheckAccessResult item in billingProfileCustomer.CheckAccessBillingPermissionsAsync(content))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // BillingRequestsListByCustomer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetBillingRequests_BillingRequestsListByCustomer()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/billingRequestsListByCustomer.json
            // this example is just showing the usage of "BillingRequests_ListByCustomer" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProfileCustomerResource created on azure
            // for more information of creating BillingProfileCustomerResource, please refer to the document of BillingProfileCustomerResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string billingProfileName = "xxxx-xxxx-xxx-xxx";
            string customerName = "11111111-1111-1111-1111-111111111111";
            ResourceIdentifier billingProfileCustomerResourceId = BillingProfileCustomerResource.CreateResourceIdentifier(billingAccountName, billingProfileName, customerName);
            BillingProfileCustomerResource billingProfileCustomer = client.GetBillingProfileCustomerResource(billingProfileCustomerResourceId);

            // invoke the operation and iterate over the result
            BillingProfileCustomerResourceGetBillingRequestsOptions options = new BillingProfileCustomerResourceGetBillingRequestsOptions() { };
            await foreach (BillingRequestResource item in billingProfileCustomer.GetBillingRequestsAsync(options))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingRequestData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // BillingRoleAssignmentCreateByCustomer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateByCustomerBillingRoleAssignment_BillingRoleAssignmentCreateByCustomer()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/billingRoleAssignmentCreateByCustomer.json
            // this example is just showing the usage of "BillingRoleAssignments_CreateByCustomer" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProfileCustomerResource created on azure
            // for more information of creating BillingProfileCustomerResource, please refer to the document of BillingProfileCustomerResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2018-09-30";
            string billingProfileName = "BKM6-54VH-BG7-PGB";
            string customerName = "703ab484-dda2-4402-827b-a74513b61e2d";
            ResourceIdentifier billingProfileCustomerResourceId = BillingProfileCustomerResource.CreateResourceIdentifier(billingAccountName, billingProfileName, customerName);
            BillingProfileCustomerResource billingProfileCustomer = client.GetBillingProfileCustomerResource(billingProfileCustomerResourceId);

            // invoke the operation
            BillingRoleAssignmentProperties billingRoleAssignmentProperties = new BillingRoleAssignmentProperties(new ResourceIdentifier("/providers/Microsoft.Billing/billingAccounts/00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2018-09-30/billingProfileName/BKM6-54VH-BG7-PGB/customers/703ab484-dda2-4402-827b-a74513b61e2d/billingRoleDefinitions/30000000-aaaa-bbbb-cccc-100000000000"))
            {
                PrincipalId = "00000000-0000-0000-0000-000000000000",
                PrincipalTenantId = Guid.Parse("076915e7-de10-4323-bb34-a58c904068bb"),
                UserEmailAddress = "john@contoso.com",
            };
            ArmOperation<BillingRoleAssignmentData> lro = await billingProfileCustomer.CreateByCustomerBillingRoleAssignmentAsync(WaitUntil.Completed, billingRoleAssignmentProperties);
            BillingRoleAssignmentData result = lro.Value;

            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {result.Id}");
        }

        // ResolveBillingRoleAssignmentByCustomer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ResolveByCustomerBillingRoleAssignment_ResolveBillingRoleAssignmentByCustomer()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/resolveBillingRoleAssignmentByCustomer.json
            // this example is just showing the usage of "BillingRoleAssignments_ResolveByCustomer" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProfileCustomerResource created on azure
            // for more information of creating BillingProfileCustomerResource, please refer to the document of BillingProfileCustomerResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2018-09-30";
            string billingProfileName = "xxxx-xxxx-xxx-xxx";
            string customerName = "703ab484-dda2-4402-827b-a74513b61e2d";
            ResourceIdentifier billingProfileCustomerResourceId = BillingProfileCustomerResource.CreateResourceIdentifier(billingAccountName, billingProfileName, customerName);
            BillingProfileCustomerResource billingProfileCustomer = client.GetBillingProfileCustomerResource(billingProfileCustomerResourceId);

            // invoke the operation
            ArmOperation<BillingRoleAssignmentListResult> lro = await billingProfileCustomer.ResolveByCustomerBillingRoleAssignmentAsync(WaitUntil.Completed);
            BillingRoleAssignmentListResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // BillingSubscriptionsListByCustomer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetBillingSubscriptions_BillingSubscriptionsListByCustomer()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/billingSubscriptionsListByCustomer.json
            // this example is just showing the usage of "BillingSubscriptions_ListByCustomer" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProfileCustomerResource created on azure
            // for more information of creating BillingProfileCustomerResource, please refer to the document of BillingProfileCustomerResource
            string billingAccountName = "a1a9c77e-4cec-4a6c-a089-867d973a6074:a80d3b1f-c626-4e5e-82ed-1173bd91c838_2019-05-31";
            string billingProfileName = "ea36e548-1505-41db-bebc-46fff3d37998";
            string customerName = "Q7GV-UUVA-PJA-TGB";
            ResourceIdentifier billingProfileCustomerResourceId = BillingProfileCustomerResource.CreateResourceIdentifier(billingAccountName, billingProfileName, customerName);
            BillingProfileCustomerResource billingProfileCustomer = client.GetBillingProfileCustomerResource(billingProfileCustomerResourceId);

            // invoke the operation and iterate over the result
            BillingProfileCustomerResourceGetBillingSubscriptionsOptions options = new BillingProfileCustomerResourceGetBillingSubscriptionsOptions() { };
            await foreach (BillingSubscriptionData item in billingProfileCustomer.GetBillingSubscriptionsAsync(options))
            {
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {item.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // CustomersGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_CustomersGet()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/customersGet.json
            // this example is just showing the usage of "Customers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProfileCustomerResource created on azure
            // for more information of creating BillingProfileCustomerResource, please refer to the document of BillingProfileCustomerResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string billingProfileName = "xxxx-xxxx-xxx-xxx";
            string customerName = "11111111-1111-1111-1111-111111111111";
            ResourceIdentifier billingProfileCustomerResourceId = BillingProfileCustomerResource.CreateResourceIdentifier(billingAccountName, billingProfileName, customerName);
            BillingProfileCustomerResource billingProfileCustomer = client.GetBillingProfileCustomerResource(billingProfileCustomerResourceId);

            // invoke the operation
            BillingProfileCustomerResource result = await billingProfileCustomer.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingCustomerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PoliciesPutByCustomer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdateByCustomerPolicy_PoliciesPutByCustomer()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/policiesPutByCustomer.json
            // this example is just showing the usage of "Policies_CreateOrUpdateByCustomer" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProfileCustomerResource created on azure
            // for more information of creating BillingProfileCustomerResource, please refer to the document of BillingProfileCustomerResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string billingProfileName = "xxxx-xxxx-xxx-xxx";
            string customerName = "11111111-1111-1111-1111-111111111111";
            ResourceIdentifier billingProfileCustomerResourceId = BillingProfileCustomerResource.CreateResourceIdentifier(billingAccountName, billingProfileName, customerName);
            BillingProfileCustomerResource billingProfileCustomer = client.GetBillingProfileCustomerResource(billingProfileCustomerResourceId);

            // invoke the operation
            BillingCustomerPolicyData data = new BillingCustomerPolicyData()
            {
                Properties = new BillingCustomerPolicyProperties(ViewChargesPolicy.Allowed),
            };
            ArmOperation<BillingCustomerPolicyData> lro = await billingProfileCustomer.CreateOrUpdateByCustomerPolicyAsync(WaitUntil.Completed, data);
            BillingCustomerPolicyData result = lro.Value;

            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {result.Id}");
        }

        // TransactionsListByCustomer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetTransactions_TransactionsListByCustomer()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/transactionsListByCustomer.json
            // this example is just showing the usage of "Transactions_ListByCustomer" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProfileCustomerResource created on azure
            // for more information of creating BillingProfileCustomerResource, please refer to the document of BillingProfileCustomerResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string billingProfileName = "xxxx-xxxx-xxx-xxx";
            string customerName = "22000000-0000-0000-0000-000000000000";
            ResourceIdentifier billingProfileCustomerResourceId = BillingProfileCustomerResource.CreateResourceIdentifier(billingAccountName, billingProfileName, customerName);
            BillingProfileCustomerResource billingProfileCustomer = client.GetBillingProfileCustomerResource(billingProfileCustomerResourceId);

            // invoke the operation and iterate over the result
            BillingProfileCustomerResourceGetTransactionsOptions options = new BillingProfileCustomerResourceGetTransactionsOptions(periodStartDate: DateTimeOffset.Parse("2024-04-01"), periodEndDate: DateTimeOffset.Parse("2023-05-30"), type: TransactionType.Billed) { Filter = "properties/date gt '2020-10-01'", Search = "storage" };
            await foreach (BillingTransactionData item in billingProfileCustomer.GetTransactionsAsync(options))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
