// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingProductResource
    {
        // ProductMove
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Move_ProductMove()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/productMove.json
            // this example is just showing the usage of "Products_Move" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProductResource created on azure
            // for more information of creating BillingProductResource, please refer to the document of BillingProductResource
            string billingAccountName = "a1a9c77e-4cec-4a6c-a089-867d973a6074:a80d3b1f-c626-4e5e-82ed-1173bd91c838_2019-05-31";
            string productName = "6b96d3f2-9008-4a9d-912f-f87744185aa3";
            ResourceIdentifier billingProductResourceId = BillingProductResource.CreateResourceIdentifier(billingAccountName, productName);
            BillingProductResource billingProduct = client.GetBillingProductResource(billingProductResourceId);

            // invoke the operation
            MoveProductContent content = new MoveProductContent(new ResourceIdentifier("/providers/Microsoft.Billing/billingAccounts/a1a9c77e-4cec-4a6c-a089-867d973a6074:a80d3b1f-c626-4e5e-82ed-1173bd91c838_2019-05-31/billingProfiles/ea36e548-1505-41db-bebc-46fff3d37998/invoiceSections/Q7GV-UUVA-PJA-TGB"));
            ArmOperation<BillingProductResource> lro = await billingProduct.MoveAsync(WaitUntil.Completed, content);
            BillingProductResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingProductData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ProductValidateMoveFailure
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ValidateMoveEligibility_ProductValidateMoveFailure()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/productValidateMoveFailure.json
            // this example is just showing the usage of "Products_ValidateMoveEligibility" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProductResource created on azure
            // for more information of creating BillingProductResource, please refer to the document of BillingProductResource
            string billingAccountName = "a1a9c77e-4cec-4a6c-a089-867d973a6074:a80d3b1f-c626-4e5e-82ed-1173bd91c838_2019-05-31";
            string productName = "6b96d3f2-9008-4a9d-912f-f87744185aa3";
            ResourceIdentifier billingProductResourceId = BillingProductResource.CreateResourceIdentifier(billingAccountName, productName);
            BillingProductResource billingProduct = client.GetBillingProductResource(billingProductResourceId);

            // invoke the operation
            MoveProductContent content = new MoveProductContent(new ResourceIdentifier("/providers/Microsoft.Billing/billingAccounts/a1a9c77e-4cec-4a6c-a089-867d973a6074:a80d3b1f-c626-4e5e-82ed-1173bd91c838_2019-05-31/billingProfiles/ea36e548-1505-41db-bebc-46fff3d37998/invoiceSections/Q7GV-UUVA-PJA-TGB"));
            MoveProductEligibilityResult result = await billingProduct.ValidateMoveEligibilityAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ProductValidateMoveSuccess
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ValidateMoveEligibility_ProductValidateMoveSuccess()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/productValidateMoveSuccess.json
            // this example is just showing the usage of "Products_ValidateMoveEligibility" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProductResource created on azure
            // for more information of creating BillingProductResource, please refer to the document of BillingProductResource
            string billingAccountName = "a1a9c77e-4cec-4a6c-a089-867d973a6074:a80d3b1f-c626-4e5e-82ed-1173bd91c838_2019-05-31";
            string productName = "6b96d3f2-9008-4a9d-912f-f87744185aa3";
            ResourceIdentifier billingProductResourceId = BillingProductResource.CreateResourceIdentifier(billingAccountName, productName);
            BillingProductResource billingProduct = client.GetBillingProductResource(billingProductResourceId);

            // invoke the operation
            MoveProductContent content = new MoveProductContent(new ResourceIdentifier("/providers/Microsoft.Billing/billingAccounts/a1a9c77e-4cec-4a6c-a089-867d973a6074:a80d3b1f-c626-4e5e-82ed-1173bd91c838_2019-05-31/billingProfiles/ea36e548-1505-41db-bebc-46fff3d37998/invoiceSections/Q7GV-UUVA-PJA-TGB"));
            MoveProductEligibilityResult result = await billingProduct.ValidateMoveEligibilityAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ProductsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ProductsGet()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/productsGet.json
            // this example is just showing the usage of "Products_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProductResource created on azure
            // for more information of creating BillingProductResource, please refer to the document of BillingProductResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string productName = "11111111-1111-1111-1111-111111111111";
            ResourceIdentifier billingProductResourceId = BillingProductResource.CreateResourceIdentifier(billingAccountName, productName);
            BillingProductResource billingProduct = client.GetBillingProductResource(billingProductResourceId);

            // invoke the operation
            BillingProductResource result = await billingProduct.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingProductData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ProductsUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ProductsUpdate()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/productsUpdate.json
            // this example is just showing the usage of "Products_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingProductResource created on azure
            // for more information of creating BillingProductResource, please refer to the document of BillingProductResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string productName = "11111111-1111-1111-1111-111111111111";
            ResourceIdentifier billingProductResourceId = BillingProductResource.CreateResourceIdentifier(billingAccountName, productName);
            BillingProductResource billingProduct = client.GetBillingProductResource(billingProductResourceId);

            // invoke the operation
            BillingProductPatch patch = new BillingProductPatch()
            {
                Properties = new BillingProductProperties()
                {
                    AutoRenew = BillingSubscriptionAutoRenewState.On,
                },
            };
            BillingProductResource result = await billingProduct.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingProductData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
