// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingPaymentMethodLinkResource
    {
        // PaymentMethodsGetByBillingProfile
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PaymentMethodsGetByBillingProfile()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/paymentMethodsGetByBillingProfile.json
            // this example is just showing the usage of "PaymentMethods_GetByBillingProfile" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingPaymentMethodLinkResource created on azure
            // for more information of creating BillingPaymentMethodLinkResource, please refer to the document of BillingPaymentMethodLinkResource
            string billingAccountName = "00000000-0000-0000-0000-000000000032:00000000-0000-0000-0000-000000000099_2019-05-31";
            string billingProfileName = "ABC1-A1CD-AB1-BP1";
            string paymentMethodName = "ABCDABCDABC0";
            ResourceIdentifier billingPaymentMethodLinkResourceId = BillingPaymentMethodLinkResource.CreateResourceIdentifier(billingAccountName, billingProfileName, paymentMethodName);
            BillingPaymentMethodLinkResource billingPaymentMethodLink = client.GetBillingPaymentMethodLinkResource(billingPaymentMethodLinkResourceId);

            // invoke the operation
            BillingPaymentMethodLinkResource result = await billingPaymentMethodLink.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingPaymentMethodLinkData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
