// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingInvoiceResource
    {
        // InvoicesAmend
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Amend_InvoicesAmend()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/invoicesAmend.json
            // this example is just showing the usage of "Invoices_Amend" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingInvoiceResource created on azure
            // for more information of creating BillingInvoiceResource, please refer to the document of BillingInvoiceResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string invoiceName = "G123456789";
            ResourceIdentifier billingInvoiceResourceId = BillingInvoiceResource.CreateResourceIdentifier(billingAccountName, invoiceName);
            BillingInvoiceResource billingInvoice = client.GetBillingInvoiceResource(billingInvoiceResourceId);

            // invoke the operation
            await billingInvoice.AmendAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // InvoicesDownloadByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DownloadByBillingAccount_InvoicesDownloadByBillingAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/invoicesDownloadByBillingAccount.json
            // this example is just showing the usage of "Invoices_DownloadByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingInvoiceResource created on azure
            // for more information of creating BillingInvoiceResource, please refer to the document of BillingInvoiceResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string invoiceName = "G123456789";
            ResourceIdentifier billingInvoiceResourceId = BillingInvoiceResource.CreateResourceIdentifier(billingAccountName, invoiceName);
            BillingInvoiceResource billingInvoice = client.GetBillingInvoiceResource(billingInvoiceResourceId);

            // invoke the operation
            string documentName = "12345678";
            ArmOperation<BillingDocumentDownloadResult> lro = await billingInvoice.DownloadByBillingAccountAsync(WaitUntil.Completed, documentName: documentName);
            BillingDocumentDownloadResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // InvoicesDownloadSummaryByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DownloadSummaryByBillingAccount_InvoicesDownloadSummaryByBillingAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/invoicesDownloadSummaryByBillingAccount.json
            // this example is just showing the usage of "Invoices_DownloadSummaryByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingInvoiceResource created on azure
            // for more information of creating BillingInvoiceResource, please refer to the document of BillingInvoiceResource
            string billingAccountName = "123456789";
            string invoiceName = "G123456789";
            ResourceIdentifier billingInvoiceResourceId = BillingInvoiceResource.CreateResourceIdentifier(billingAccountName, invoiceName);
            BillingInvoiceResource billingInvoice = client.GetBillingInvoiceResource(billingInvoiceResourceId);

            // invoke the operation
            ArmOperation<BillingDocumentDownloadResult> lro = await billingInvoice.DownloadSummaryByBillingAccountAsync(WaitUntil.Completed);
            BillingDocumentDownloadResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // InvoicesGetByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_InvoicesGetByBillingAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/invoicesGetByBillingAccount.json
            // this example is just showing the usage of "Invoices_GetByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingInvoiceResource created on azure
            // for more information of creating BillingInvoiceResource, please refer to the document of BillingInvoiceResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string invoiceName = "G123456789";
            ResourceIdentifier billingInvoiceResourceId = BillingInvoiceResource.CreateResourceIdentifier(billingAccountName, invoiceName);
            BillingInvoiceResource billingInvoice = client.GetBillingInvoiceResource(billingInvoiceResourceId);

            // invoke the operation
            BillingInvoiceResource result = await billingInvoice.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingInvoiceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // TransactionsListByInvoice
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetTransactions_TransactionsListByInvoice()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/transactionsListByInvoice.json
            // this example is just showing the usage of "Transactions_ListByInvoice" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingInvoiceResource created on azure
            // for more information of creating BillingInvoiceResource, please refer to the document of BillingInvoiceResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string invoiceName = "G123456789";
            ResourceIdentifier billingInvoiceResourceId = BillingInvoiceResource.CreateResourceIdentifier(billingAccountName, invoiceName);
            BillingInvoiceResource billingInvoice = client.GetBillingInvoiceResource(billingInvoiceResourceId);

            // invoke the operation and iterate over the result
            BillingInvoiceResourceGetTransactionsOptions options = new BillingInvoiceResourceGetTransactionsOptions() { };
            await foreach (BillingTransactionData item in billingInvoice.GetTransactionsAsync(options))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // TransactionsDownloadByInvoice
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TransactionsDownloadByInvoiceTransaction_TransactionsDownloadByInvoice()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/transactionsDownloadByInvoice.json
            // this example is just showing the usage of "Transactions_TransactionsDownloadByInvoice" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingInvoiceResource created on azure
            // for more information of creating BillingInvoiceResource, please refer to the document of BillingInvoiceResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string invoiceName = "G123456789";
            ResourceIdentifier billingInvoiceResourceId = BillingInvoiceResource.CreateResourceIdentifier(billingAccountName, invoiceName);
            BillingInvoiceResource billingInvoice = client.GetBillingInvoiceResource(billingInvoiceResourceId);

            // invoke the operation
            ArmOperation<BillingDocumentDownloadResult> lro = await billingInvoice.TransactionsDownloadByInvoiceTransactionAsync(WaitUntil.Completed);
            BillingDocumentDownloadResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // TransactionSummaryGetByInvoice
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetTransactionSummaryByInvoiceTransaction_TransactionSummaryGetByInvoice()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/transactionSummaryGetByInvoice.json
            // this example is just showing the usage of "Transactions_GetTransactionSummaryByInvoice" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingInvoiceResource created on azure
            // for more information of creating BillingInvoiceResource, please refer to the document of BillingInvoiceResource
            string billingAccountName = "00000000-0000-0000-0000-000000000000:00000000-0000-0000-0000-000000000000_2019-05-31";
            string invoiceName = "G123456789";
            ResourceIdentifier billingInvoiceResourceId = BillingInvoiceResource.CreateResourceIdentifier(billingAccountName, invoiceName);
            BillingInvoiceResource billingInvoice = client.GetBillingInvoiceResource(billingInvoiceResourceId);

            // invoke the operation
            BillingTransactionSummary result = await billingInvoice.GetTransactionSummaryByInvoiceTransactionAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
