// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingEnrollmentAccountRoleAssignmentCollection
    {
        // BillingRoleAssignmentGetByEnrollmentAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_BillingRoleAssignmentGetByEnrollmentAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/billingRoleAssignmentGetByEnrollmentAccount.json
            // this example is just showing the usage of "BillingRoleAssignments_GetByEnrollmentAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingEnrollmentAccountResource created on azure
            // for more information of creating BillingEnrollmentAccountResource, please refer to the document of BillingEnrollmentAccountResource
            string billingAccountName = "7898901";
            string enrollmentAccountName = "225314";
            ResourceIdentifier billingEnrollmentAccountResourceId = BillingEnrollmentAccountResource.CreateResourceIdentifier(billingAccountName, enrollmentAccountName);
            BillingEnrollmentAccountResource billingEnrollmentAccount = client.GetBillingEnrollmentAccountResource(billingEnrollmentAccountResourceId);

            // get the collection of this BillingEnrollmentAccountRoleAssignmentResource
            BillingEnrollmentAccountRoleAssignmentCollection collection = billingEnrollmentAccount.GetBillingEnrollmentAccountRoleAssignments();

            // invoke the operation
            string billingRoleAssignmentName = "9dfd08c2-62a3-4d47-85bd-1cdba1408402";
            BillingEnrollmentAccountRoleAssignmentResource result = await collection.GetAsync(billingRoleAssignmentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingRoleAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // BillingRoleAssignmentGetByEnrollmentAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_BillingRoleAssignmentGetByEnrollmentAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/billingRoleAssignmentGetByEnrollmentAccount.json
            // this example is just showing the usage of "BillingRoleAssignments_GetByEnrollmentAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingEnrollmentAccountResource created on azure
            // for more information of creating BillingEnrollmentAccountResource, please refer to the document of BillingEnrollmentAccountResource
            string billingAccountName = "7898901";
            string enrollmentAccountName = "225314";
            ResourceIdentifier billingEnrollmentAccountResourceId = BillingEnrollmentAccountResource.CreateResourceIdentifier(billingAccountName, enrollmentAccountName);
            BillingEnrollmentAccountResource billingEnrollmentAccount = client.GetBillingEnrollmentAccountResource(billingEnrollmentAccountResourceId);

            // get the collection of this BillingEnrollmentAccountRoleAssignmentResource
            BillingEnrollmentAccountRoleAssignmentCollection collection = billingEnrollmentAccount.GetBillingEnrollmentAccountRoleAssignments();

            // invoke the operation
            string billingRoleAssignmentName = "9dfd08c2-62a3-4d47-85bd-1cdba1408402";
            bool result = await collection.ExistsAsync(billingRoleAssignmentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // BillingRoleAssignmentGetByEnrollmentAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_BillingRoleAssignmentGetByEnrollmentAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/billingRoleAssignmentGetByEnrollmentAccount.json
            // this example is just showing the usage of "BillingRoleAssignments_GetByEnrollmentAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingEnrollmentAccountResource created on azure
            // for more information of creating BillingEnrollmentAccountResource, please refer to the document of BillingEnrollmentAccountResource
            string billingAccountName = "7898901";
            string enrollmentAccountName = "225314";
            ResourceIdentifier billingEnrollmentAccountResourceId = BillingEnrollmentAccountResource.CreateResourceIdentifier(billingAccountName, enrollmentAccountName);
            BillingEnrollmentAccountResource billingEnrollmentAccount = client.GetBillingEnrollmentAccountResource(billingEnrollmentAccountResourceId);

            // get the collection of this BillingEnrollmentAccountRoleAssignmentResource
            BillingEnrollmentAccountRoleAssignmentCollection collection = billingEnrollmentAccount.GetBillingEnrollmentAccountRoleAssignments();

            // invoke the operation
            string billingRoleAssignmentName = "9dfd08c2-62a3-4d47-85bd-1cdba1408402";
            NullableResponse<BillingEnrollmentAccountRoleAssignmentResource> response = await collection.GetIfExistsAsync(billingRoleAssignmentName);
            BillingEnrollmentAccountRoleAssignmentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingRoleAssignmentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // BillingRoleAssignmentCreateOrUpdateByEnrollmentAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_BillingRoleAssignmentCreateOrUpdateByEnrollmentAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/billingRoleAssignmentCreateOrUpdateByEnrollmentAccount.json
            // this example is just showing the usage of "BillingRoleAssignments_CreateOrUpdateByEnrollmentAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingEnrollmentAccountResource created on azure
            // for more information of creating BillingEnrollmentAccountResource, please refer to the document of BillingEnrollmentAccountResource
            string billingAccountName = "7898901";
            string enrollmentAccountName = "123456";
            ResourceIdentifier billingEnrollmentAccountResourceId = BillingEnrollmentAccountResource.CreateResourceIdentifier(billingAccountName, enrollmentAccountName);
            BillingEnrollmentAccountResource billingEnrollmentAccount = client.GetBillingEnrollmentAccountResource(billingEnrollmentAccountResourceId);

            // get the collection of this BillingEnrollmentAccountRoleAssignmentResource
            BillingEnrollmentAccountRoleAssignmentCollection collection = billingEnrollmentAccount.GetBillingEnrollmentAccountRoleAssignments();

            // invoke the operation
            string billingRoleAssignmentName = "9dfd08c2-62a3-4d47-85bd-1cdba1408402";
            BillingRoleAssignmentData data = new BillingRoleAssignmentData()
            {
                Properties = new BillingRoleAssignmentProperties(new ResourceIdentifier("/providers/Microsoft.Billing/billingAccounts/7898901/enrollmentAccounts/123456/billingRoleDefinitions/9f1983cb-2574-400c-87e9-34cf8e2280db"))
                {
                    PrincipalId = "00000000-0000-0000-0000-000000000000",
                    PrincipalTenantId = Guid.Parse("076915e7-de10-4323-bb34-a58c904068bb"),
                    UserEmailAddress = "john@contoso.com",
                },
            };
            ArmOperation<BillingEnrollmentAccountRoleAssignmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, billingRoleAssignmentName, data);
            BillingEnrollmentAccountRoleAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingRoleAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // BillingRoleAssignmentListByEnrollmentAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_BillingRoleAssignmentListByEnrollmentAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/billingRoleAssignmentListByEnrollmentAccount.json
            // this example is just showing the usage of "BillingRoleAssignments_ListByEnrollmentAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingEnrollmentAccountResource created on azure
            // for more information of creating BillingEnrollmentAccountResource, please refer to the document of BillingEnrollmentAccountResource
            string billingAccountName = "6100092";
            string enrollmentAccountName = "123456";
            ResourceIdentifier billingEnrollmentAccountResourceId = BillingEnrollmentAccountResource.CreateResourceIdentifier(billingAccountName, enrollmentAccountName);
            BillingEnrollmentAccountResource billingEnrollmentAccount = client.GetBillingEnrollmentAccountResource(billingEnrollmentAccountResourceId);

            // get the collection of this BillingEnrollmentAccountRoleAssignmentResource
            BillingEnrollmentAccountRoleAssignmentCollection collection = billingEnrollmentAccount.GetBillingEnrollmentAccountRoleAssignments();

            // invoke the operation and iterate over the result
            await foreach (BillingEnrollmentAccountRoleAssignmentResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BillingRoleAssignmentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
