// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingDepartmentRoleDefinitionResource
    {
        // BillingRoleDefinitionGetByDepartment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_BillingRoleDefinitionGetByDepartment()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/billingRoleDefinitionGetByDepartment.json
            // this example is just showing the usage of "BillingRoleDefinition_GetByDepartment" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingDepartmentRoleDefinitionResource created on azure
            // for more information of creating BillingDepartmentRoleDefinitionResource, please refer to the document of BillingDepartmentRoleDefinitionResource
            string billingAccountName = "123456";
            string departmentName = "7368531";
            string roleDefinitionName = "50000000-aaaa-bbbb-cccc-100000000000";
            ResourceIdentifier billingDepartmentRoleDefinitionResourceId = BillingDepartmentRoleDefinitionResource.CreateResourceIdentifier(billingAccountName, departmentName, roleDefinitionName);
            BillingDepartmentRoleDefinitionResource billingDepartmentRoleDefinition = client.GetBillingDepartmentRoleDefinitionResource(billingDepartmentRoleDefinitionResourceId);

            // invoke the operation
            BillingDepartmentRoleDefinitionResource result = await billingDepartmentRoleDefinition.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingRoleDefinitionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
