// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingDepartmentEnrollmentAccountResource
    {
        // EnrollmentAccountByDepartment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_EnrollmentAccountByDepartment()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/enrollmentAccountByDepartment.json
            // this example is just showing the usage of "EnrollmentAccounts_GetByDepartment" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingDepartmentEnrollmentAccountResource created on azure
            // for more information of creating BillingDepartmentEnrollmentAccountResource, please refer to the document of BillingDepartmentEnrollmentAccountResource
            string billingAccountName = "6564892";
            string departmentName = "164821";
            string enrollmentAccountName = "257698";
            ResourceIdentifier billingDepartmentEnrollmentAccountResourceId = BillingDepartmentEnrollmentAccountResource.CreateResourceIdentifier(billingAccountName, departmentName, enrollmentAccountName);
            BillingDepartmentEnrollmentAccountResource billingDepartmentEnrollmentAccount = client.GetBillingDepartmentEnrollmentAccountResource(billingDepartmentEnrollmentAccountResourceId);

            // invoke the operation
            BillingDepartmentEnrollmentAccountResource result = await billingDepartmentEnrollmentAccount.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingEnrollmentAccountData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
