// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Billing.Models;

namespace Azure.ResourceManager.Billing.Samples
{
    public partial class Sample_BillingAccountPolicyResource
    {
        // PoliciesGetByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PoliciesGetByBillingAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/policiesGetByBillingAccount.json
            // this example is just showing the usage of "Policies_GetByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingAccountPolicyResource created on azure
            // for more information of creating BillingAccountPolicyResource, please refer to the document of BillingAccountPolicyResource
            string billingAccountName = "1234567";
            ResourceIdentifier billingAccountPolicyResourceId = BillingAccountPolicyResource.CreateResourceIdentifier(billingAccountName);
            BillingAccountPolicyResource billingAccountPolicy = client.GetBillingAccountPolicyResource(billingAccountPolicyResourceId);

            // invoke the operation
            BillingAccountPolicyResource result = await billingAccountPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingAccountPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PoliciesPutByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_PoliciesPutByBillingAccount()
        {
            // Generated from example definition: specification/billing/resource-manager/Microsoft.Billing/stable/2024-04-01/examples/policiesPutByBillingAccount.json
            // this example is just showing the usage of "Policies_CreateOrUpdateByBillingAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BillingAccountPolicyResource created on azure
            // for more information of creating BillingAccountPolicyResource, please refer to the document of BillingAccountPolicyResource
            string billingAccountName = "1234567";
            ResourceIdentifier billingAccountPolicyResourceId = BillingAccountPolicyResource.CreateResourceIdentifier(billingAccountName);
            BillingAccountPolicyResource billingAccountPolicy = client.GetBillingAccountPolicyResource(billingAccountPolicyResourceId);

            // invoke the operation
            BillingAccountPolicyData data = new BillingAccountPolicyData()
            {
                Properties = new BillingAccountPolicyProperties()
                {
                    EnterpriseAgreementPolicies = new EnterpriseAgreementPolicies()
                    {
                        AuthenticationType = EnrollmentAuthLevelState.OrganizationalAccountOnly,
                    },
                    MarketplacePurchases = MarketplacePurchasesPolicy.AllAllowed,
                    ReservationPurchases = ReservationPurchasesPolicy.Allowed,
                    SavingsPlanPurchases = SavingsPlanPurchasesPolicy.NotAllowed,
                },
            };
            ArmOperation<BillingAccountPolicyResource> lro = await billingAccountPolicy.CreateOrUpdateAsync(WaitUntil.Completed, data);
            BillingAccountPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BillingAccountPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
