// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for PoolOperations.
    /// </summary>
    public static partial class PoolOperationsExtensions
    {
            /// <summary>
            /// Lists the usage metrics, aggregated by Pool across individual time
            /// intervals, for the specified Account.
            /// </summary>
            /// <remarks>
            /// If you do not specify a $filter clause including a poolId, the response
            /// includes all Pools that existed in the Account in the time range of the
            /// returned aggregation intervals. If you do not specify a $filter clause
            /// including a startTime or endTime these filters default to the start and end
            /// times of the last aggregation interval currently available; that is, only
            /// the last aggregation interval is returned.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolListUsageMetricsOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<PoolUsageMetrics> ListUsageMetrics(this IPoolOperations operations, PoolListUsageMetricsOptions poolListUsageMetricsOptions = default(PoolListUsageMetricsOptions))
            {
                return operations.ListUsageMetricsAsync(poolListUsageMetricsOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists the usage metrics, aggregated by Pool across individual time
            /// intervals, for the specified Account.
            /// </summary>
            /// <remarks>
            /// If you do not specify a $filter clause including a poolId, the response
            /// includes all Pools that existed in the Account in the time range of the
            /// returned aggregation intervals. If you do not specify a $filter clause
            /// including a startTime or endTime these filters default to the start and end
            /// times of the last aggregation interval currently available; that is, only
            /// the last aggregation interval is returned.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolListUsageMetricsOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<PoolUsageMetrics>> ListUsageMetricsAsync(this IPoolOperations operations, PoolListUsageMetricsOptions poolListUsageMetricsOptions = default(PoolListUsageMetricsOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListUsageMetricsWithHttpMessagesAsync(poolListUsageMetricsOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds a Pool to the specified Account.
            /// </summary>
            /// <remarks>
            /// When naming Pools, avoid including sensitive information such as user names
            /// or secret project names. This information may appear in telemetry logs
            /// accessible to Microsoft Support engineers.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='pool'>
            /// The Pool to be added.
            /// </param>
            /// <param name='poolAddOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static PoolAddHeaders Add(this IPoolOperations operations, PoolAddParameter pool, PoolAddOptions poolAddOptions = default(PoolAddOptions))
            {
                return operations.AddAsync(pool, poolAddOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Adds a Pool to the specified Account.
            /// </summary>
            /// <remarks>
            /// When naming Pools, avoid including sensitive information such as user names
            /// or secret project names. This information may appear in telemetry logs
            /// accessible to Microsoft Support engineers.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='pool'>
            /// The Pool to be added.
            /// </param>
            /// <param name='poolAddOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PoolAddHeaders> AddAsync(this IPoolOperations operations, PoolAddParameter pool, PoolAddOptions poolAddOptions = default(PoolAddOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddWithHttpMessagesAsync(pool, poolAddOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Lists all of the Pools which be mounted
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolListOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<CloudPool> List(this IPoolOperations operations, PoolListOptions poolListOptions = default(PoolListOptions))
            {
                return operations.ListAsync(poolListOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists all of the Pools which be mounted
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolListOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<CloudPool>> ListAsync(this IPoolOperations operations, PoolListOptions poolListOptions = default(PoolListOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListWithHttpMessagesAsync(poolListOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a Pool from the specified Account.
            /// </summary>
            /// <remarks>
            /// When you request that a Pool be deleted, the following actions occur: the
            /// Pool state is set to deleting; any ongoing resize operation on the Pool are
            /// stopped; the Batch service starts resizing the Pool to zero Compute Nodes;
            /// any Tasks running on existing Compute Nodes are terminated and requeued (as
            /// if a resize Pool operation had been requested with the default requeue
            /// option); finally, the Pool is removed from the system. Because running
            /// Tasks are requeued, the user can rerun these Tasks by updating their Job to
            /// target a different Pool. The Tasks can then run on the new Pool. If you
            /// want to override the requeue behavior, then you should call resize Pool
            /// explicitly to shrink the Pool to zero size before deleting the Pool. If you
            /// call an Update, Patch or Delete API on a Pool in the deleting state, it
            /// will fail with HTTP status code 409 with error code PoolBeingDeleted.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to delete.
            /// </param>
            /// <param name='poolDeleteOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static PoolDeleteHeaders Delete(this IPoolOperations operations, string poolId, PoolDeleteOptions poolDeleteOptions = default(PoolDeleteOptions))
            {
                return operations.DeleteAsync(poolId, poolDeleteOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Deletes a Pool from the specified Account.
            /// </summary>
            /// <remarks>
            /// When you request that a Pool be deleted, the following actions occur: the
            /// Pool state is set to deleting; any ongoing resize operation on the Pool are
            /// stopped; the Batch service starts resizing the Pool to zero Compute Nodes;
            /// any Tasks running on existing Compute Nodes are terminated and requeued (as
            /// if a resize Pool operation had been requested with the default requeue
            /// option); finally, the Pool is removed from the system. Because running
            /// Tasks are requeued, the user can rerun these Tasks by updating their Job to
            /// target a different Pool. The Tasks can then run on the new Pool. If you
            /// want to override the requeue behavior, then you should call resize Pool
            /// explicitly to shrink the Pool to zero size before deleting the Pool. If you
            /// call an Update, Patch or Delete API on a Pool in the deleting state, it
            /// will fail with HTTP status code 409 with error code PoolBeingDeleted.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to delete.
            /// </param>
            /// <param name='poolDeleteOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PoolDeleteHeaders> DeleteAsync(this IPoolOperations operations, string poolId, PoolDeleteOptions poolDeleteOptions = default(PoolDeleteOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteWithHttpMessagesAsync(poolId, poolDeleteOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Gets basic properties of a Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to get.
            /// </param>
            /// <param name='poolExistsOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static bool Exists(this IPoolOperations operations, string poolId, PoolExistsOptions poolExistsOptions = default(PoolExistsOptions))
            {
                return operations.ExistsAsync(poolId, poolExistsOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets basic properties of a Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to get.
            /// </param>
            /// <param name='poolExistsOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<bool> ExistsAsync(this IPoolOperations operations, string poolId, PoolExistsOptions poolExistsOptions = default(PoolExistsOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ExistsWithHttpMessagesAsync(poolId, poolExistsOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about the specified Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to get.
            /// </param>
            /// <param name='poolGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static CloudPool Get(this IPoolOperations operations, string poolId, PoolGetOptions poolGetOptions = default(PoolGetOptions))
            {
                return operations.GetAsync(poolId, poolGetOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets information about the specified Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to get.
            /// </param>
            /// <param name='poolGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<CloudPool> GetAsync(this IPoolOperations operations, string poolId, PoolGetOptions poolGetOptions = default(PoolGetOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(poolId, poolGetOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the properties of the specified Pool.
            /// </summary>
            /// <remarks>
            /// This only replaces the Pool properties specified in the request. For
            /// example, if the Pool has a StartTask associated with it, and a request does
            /// not specify a StartTask element, then the Pool keeps the existing
            /// StartTask.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to update.
            /// </param>
            /// <param name='poolPatchParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='poolPatchOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static PoolPatchHeaders Patch(this IPoolOperations operations, string poolId, PoolPatchParameter poolPatchParameter, PoolPatchOptions poolPatchOptions = default(PoolPatchOptions))
            {
                return operations.PatchAsync(poolId, poolPatchParameter, poolPatchOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Updates the properties of the specified Pool.
            /// </summary>
            /// <remarks>
            /// This only replaces the Pool properties specified in the request. For
            /// example, if the Pool has a StartTask associated with it, and a request does
            /// not specify a StartTask element, then the Pool keeps the existing
            /// StartTask.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to update.
            /// </param>
            /// <param name='poolPatchParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='poolPatchOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PoolPatchHeaders> PatchAsync(this IPoolOperations operations, string poolId, PoolPatchParameter poolPatchParameter, PoolPatchOptions poolPatchOptions = default(PoolPatchOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.PatchWithHttpMessagesAsync(poolId, poolPatchParameter, poolPatchOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Disables automatic scaling for a Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool on which to disable automatic scaling.
            /// </param>
            /// <param name='poolDisableAutoScaleOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static PoolDisableAutoScaleHeaders DisableAutoScale(this IPoolOperations operations, string poolId, PoolDisableAutoScaleOptions poolDisableAutoScaleOptions = default(PoolDisableAutoScaleOptions))
            {
                return operations.DisableAutoScaleAsync(poolId, poolDisableAutoScaleOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Disables automatic scaling for a Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool on which to disable automatic scaling.
            /// </param>
            /// <param name='poolDisableAutoScaleOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PoolDisableAutoScaleHeaders> DisableAutoScaleAsync(this IPoolOperations operations, string poolId, PoolDisableAutoScaleOptions poolDisableAutoScaleOptions = default(PoolDisableAutoScaleOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DisableAutoScaleWithHttpMessagesAsync(poolId, poolDisableAutoScaleOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Enables automatic scaling for a Pool.
            /// </summary>
            /// <remarks>
            /// You cannot enable automatic scaling on a Pool if a resize operation is in
            /// progress on the Pool. If automatic scaling of the Pool is currently
            /// disabled, you must specify a valid autoscale formula as part of the
            /// request. If automatic scaling of the Pool is already enabled, you may
            /// specify a new autoscale formula and/or a new evaluation interval. You
            /// cannot call this API for the same Pool more than once every 30 seconds.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool on which to enable automatic scaling.
            /// </param>
            /// <param name='poolEnableAutoScaleParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='poolEnableAutoScaleOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static PoolEnableAutoScaleHeaders EnableAutoScale(this IPoolOperations operations, string poolId, PoolEnableAutoScaleParameter poolEnableAutoScaleParameter, PoolEnableAutoScaleOptions poolEnableAutoScaleOptions = default(PoolEnableAutoScaleOptions))
            {
                return operations.EnableAutoScaleAsync(poolId, poolEnableAutoScaleParameter, poolEnableAutoScaleOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Enables automatic scaling for a Pool.
            /// </summary>
            /// <remarks>
            /// You cannot enable automatic scaling on a Pool if a resize operation is in
            /// progress on the Pool. If automatic scaling of the Pool is currently
            /// disabled, you must specify a valid autoscale formula as part of the
            /// request. If automatic scaling of the Pool is already enabled, you may
            /// specify a new autoscale formula and/or a new evaluation interval. You
            /// cannot call this API for the same Pool more than once every 30 seconds.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool on which to enable automatic scaling.
            /// </param>
            /// <param name='poolEnableAutoScaleParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='poolEnableAutoScaleOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PoolEnableAutoScaleHeaders> EnableAutoScaleAsync(this IPoolOperations operations, string poolId, PoolEnableAutoScaleParameter poolEnableAutoScaleParameter, PoolEnableAutoScaleOptions poolEnableAutoScaleOptions = default(PoolEnableAutoScaleOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.EnableAutoScaleWithHttpMessagesAsync(poolId, poolEnableAutoScaleParameter, poolEnableAutoScaleOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Gets the result of evaluating an automatic scaling formula on the Pool.
            /// </summary>
            /// <remarks>
            /// This API is primarily for validating an autoscale formula, as it simply
            /// returns the result without applying the formula to the Pool. The Pool must
            /// have auto scaling enabled in order to evaluate a formula.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool on which to evaluate the automatic scaling formula.
            /// </param>
            /// <param name='autoScaleFormula'>
            /// The formula for the desired number of Compute Nodes in the Pool. The
            /// formula is validated and its results calculated, but it is not applied to
            /// the Pool. To apply the formula to the Pool, 'Enable automatic scaling on a
            /// Pool'. For more information about specifying this formula, see
            /// Automatically scale Compute Nodes in an Azure Batch Pool
            /// (https://azure.microsoft.com/documentation/articles/batch-automatic-scaling).
            /// </param>
            /// <param name='poolEvaluateAutoScaleOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static AutoScaleRun EvaluateAutoScale(this IPoolOperations operations, string poolId, string autoScaleFormula, PoolEvaluateAutoScaleOptions poolEvaluateAutoScaleOptions = default(PoolEvaluateAutoScaleOptions))
            {
                return operations.EvaluateAutoScaleAsync(poolId, autoScaleFormula, poolEvaluateAutoScaleOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the result of evaluating an automatic scaling formula on the Pool.
            /// </summary>
            /// <remarks>
            /// This API is primarily for validating an autoscale formula, as it simply
            /// returns the result without applying the formula to the Pool. The Pool must
            /// have auto scaling enabled in order to evaluate a formula.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool on which to evaluate the automatic scaling formula.
            /// </param>
            /// <param name='autoScaleFormula'>
            /// The formula for the desired number of Compute Nodes in the Pool. The
            /// formula is validated and its results calculated, but it is not applied to
            /// the Pool. To apply the formula to the Pool, 'Enable automatic scaling on a
            /// Pool'. For more information about specifying this formula, see
            /// Automatically scale Compute Nodes in an Azure Batch Pool
            /// (https://azure.microsoft.com/documentation/articles/batch-automatic-scaling).
            /// </param>
            /// <param name='poolEvaluateAutoScaleOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<AutoScaleRun> EvaluateAutoScaleAsync(this IPoolOperations operations, string poolId, string autoScaleFormula, PoolEvaluateAutoScaleOptions poolEvaluateAutoScaleOptions = default(PoolEvaluateAutoScaleOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.EvaluateAutoScaleWithHttpMessagesAsync(poolId, autoScaleFormula, poolEvaluateAutoScaleOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Changes the number of Compute Nodes that are assigned to a Pool.
            /// </summary>
            /// <remarks>
            /// You can only resize a Pool when its allocation state is steady. If the Pool
            /// is already resizing, the request fails with status code 409. When you
            /// resize a Pool, the Pool's allocation state changes from steady to resizing.
            /// You cannot resize Pools which are configured for automatic scaling. If you
            /// try to do this, the Batch service returns an error 409. If you resize a
            /// Pool downwards, the Batch service chooses which Compute Nodes to remove. To
            /// remove specific Compute Nodes, use the Pool remove Compute Nodes API
            /// instead.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to resize.
            /// </param>
            /// <param name='poolResizeParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='poolResizeOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static PoolResizeHeaders Resize(this IPoolOperations operations, string poolId, PoolResizeParameter poolResizeParameter, PoolResizeOptions poolResizeOptions = default(PoolResizeOptions))
            {
                return operations.ResizeAsync(poolId, poolResizeParameter, poolResizeOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Changes the number of Compute Nodes that are assigned to a Pool.
            /// </summary>
            /// <remarks>
            /// You can only resize a Pool when its allocation state is steady. If the Pool
            /// is already resizing, the request fails with status code 409. When you
            /// resize a Pool, the Pool's allocation state changes from steady to resizing.
            /// You cannot resize Pools which are configured for automatic scaling. If you
            /// try to do this, the Batch service returns an error 409. If you resize a
            /// Pool downwards, the Batch service chooses which Compute Nodes to remove. To
            /// remove specific Compute Nodes, use the Pool remove Compute Nodes API
            /// instead.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to resize.
            /// </param>
            /// <param name='poolResizeParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='poolResizeOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PoolResizeHeaders> ResizeAsync(this IPoolOperations operations, string poolId, PoolResizeParameter poolResizeParameter, PoolResizeOptions poolResizeOptions = default(PoolResizeOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ResizeWithHttpMessagesAsync(poolId, poolResizeParameter, poolResizeOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Stops an ongoing resize operation on the Pool.
            /// </summary>
            /// <remarks>
            /// This does not restore the Pool to its previous state before the resize
            /// operation: it only stops any further changes being made, and the Pool
            /// maintains its current state. After stopping, the Pool stabilizes at the
            /// number of Compute Nodes it was at when the stop operation was done. During
            /// the stop operation, the Pool allocation state changes first to stopping and
            /// then to steady. A resize operation need not be an explicit resize Pool
            /// request; this API can also be used to halt the initial sizing of the Pool
            /// when it is created.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool whose resizing you want to stop.
            /// </param>
            /// <param name='poolStopResizeOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static PoolStopResizeHeaders StopResize(this IPoolOperations operations, string poolId, PoolStopResizeOptions poolStopResizeOptions = default(PoolStopResizeOptions))
            {
                return operations.StopResizeAsync(poolId, poolStopResizeOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Stops an ongoing resize operation on the Pool.
            /// </summary>
            /// <remarks>
            /// This does not restore the Pool to its previous state before the resize
            /// operation: it only stops any further changes being made, and the Pool
            /// maintains its current state. After stopping, the Pool stabilizes at the
            /// number of Compute Nodes it was at when the stop operation was done. During
            /// the stop operation, the Pool allocation state changes first to stopping and
            /// then to steady. A resize operation need not be an explicit resize Pool
            /// request; this API can also be used to halt the initial sizing of the Pool
            /// when it is created.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool whose resizing you want to stop.
            /// </param>
            /// <param name='poolStopResizeOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PoolStopResizeHeaders> StopResizeAsync(this IPoolOperations operations, string poolId, PoolStopResizeOptions poolStopResizeOptions = default(PoolStopResizeOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.StopResizeWithHttpMessagesAsync(poolId, poolStopResizeOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Updates the properties of the specified Pool.
            /// </summary>
            /// <remarks>
            /// This fully replaces all the updatable properties of the Pool. For example,
            /// if the Pool has a StartTask associated with it and if StartTask is not
            /// specified with this request, then the Batch service will remove the
            /// existing StartTask.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to update.
            /// </param>
            /// <param name='poolUpdatePropertiesParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='poolUpdatePropertiesOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static PoolUpdatePropertiesHeaders UpdateProperties(this IPoolOperations operations, string poolId, PoolUpdatePropertiesParameter poolUpdatePropertiesParameter, PoolUpdatePropertiesOptions poolUpdatePropertiesOptions = default(PoolUpdatePropertiesOptions))
            {
                return operations.UpdatePropertiesAsync(poolId, poolUpdatePropertiesParameter, poolUpdatePropertiesOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Updates the properties of the specified Pool.
            /// </summary>
            /// <remarks>
            /// This fully replaces all the updatable properties of the Pool. For example,
            /// if the Pool has a StartTask associated with it and if StartTask is not
            /// specified with this request, then the Batch service will remove the
            /// existing StartTask.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool to update.
            /// </param>
            /// <param name='poolUpdatePropertiesParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='poolUpdatePropertiesOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PoolUpdatePropertiesHeaders> UpdatePropertiesAsync(this IPoolOperations operations, string poolId, PoolUpdatePropertiesParameter poolUpdatePropertiesParameter, PoolUpdatePropertiesOptions poolUpdatePropertiesOptions = default(PoolUpdatePropertiesOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdatePropertiesWithHttpMessagesAsync(poolId, poolUpdatePropertiesParameter, poolUpdatePropertiesOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Removes Compute Nodes from the specified Pool.
            /// </summary>
            /// <remarks>
            /// This operation can only run when the allocation state of the Pool is
            /// steady. When this operation runs, the allocation state changes from steady
            /// to resizing. Each request may remove up to 100 nodes.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool from which you want to remove Compute Nodes.
            /// </param>
            /// <param name='nodeRemoveParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='poolRemoveNodesOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static PoolRemoveNodesHeaders RemoveNodes(this IPoolOperations operations, string poolId, NodeRemoveParameter nodeRemoveParameter, PoolRemoveNodesOptions poolRemoveNodesOptions = default(PoolRemoveNodesOptions))
            {
                return operations.RemoveNodesAsync(poolId, nodeRemoveParameter, poolRemoveNodesOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Removes Compute Nodes from the specified Pool.
            /// </summary>
            /// <remarks>
            /// This operation can only run when the allocation state of the Pool is
            /// steady. When this operation runs, the allocation state changes from steady
            /// to resizing. Each request may remove up to 100 nodes.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool from which you want to remove Compute Nodes.
            /// </param>
            /// <param name='nodeRemoveParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='poolRemoveNodesOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PoolRemoveNodesHeaders> RemoveNodesAsync(this IPoolOperations operations, string poolId, NodeRemoveParameter nodeRemoveParameter, PoolRemoveNodesOptions poolRemoveNodesOptions = default(PoolRemoveNodesOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.RemoveNodesWithHttpMessagesAsync(poolId, nodeRemoveParameter, poolRemoveNodesOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Lists the usage metrics, aggregated by Pool across individual time
            /// intervals, for the specified Account.
            /// </summary>
            /// <remarks>
            /// If you do not specify a $filter clause including a poolId, the response
            /// includes all Pools that existed in the Account in the time range of the
            /// returned aggregation intervals. If you do not specify a $filter clause
            /// including a startTime or endTime these filters default to the start and end
            /// times of the last aggregation interval currently available; that is, only
            /// the last aggregation interval is returned.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='poolListUsageMetricsNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<PoolUsageMetrics> ListUsageMetricsNext(this IPoolOperations operations, string nextPageLink, PoolListUsageMetricsNextOptions poolListUsageMetricsNextOptions = default(PoolListUsageMetricsNextOptions))
            {
                return operations.ListUsageMetricsNextAsync(nextPageLink, poolListUsageMetricsNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists the usage metrics, aggregated by Pool across individual time
            /// intervals, for the specified Account.
            /// </summary>
            /// <remarks>
            /// If you do not specify a $filter clause including a poolId, the response
            /// includes all Pools that existed in the Account in the time range of the
            /// returned aggregation intervals. If you do not specify a $filter clause
            /// including a startTime or endTime these filters default to the start and end
            /// times of the last aggregation interval currently available; that is, only
            /// the last aggregation interval is returned.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='poolListUsageMetricsNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<PoolUsageMetrics>> ListUsageMetricsNextAsync(this IPoolOperations operations, string nextPageLink, PoolListUsageMetricsNextOptions poolListUsageMetricsNextOptions = default(PoolListUsageMetricsNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListUsageMetricsNextWithHttpMessagesAsync(nextPageLink, poolListUsageMetricsNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists all of the Pools which be mounted
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='poolListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<CloudPool> ListNext(this IPoolOperations operations, string nextPageLink, PoolListNextOptions poolListNextOptions = default(PoolListNextOptions))
            {
                return operations.ListNextAsync(nextPageLink, poolListNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists all of the Pools which be mounted
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='poolListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<CloudPool>> ListNextAsync(this IPoolOperations operations, string nextPageLink, PoolListNextOptions poolListNextOptions = default(PoolListNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListNextWithHttpMessagesAsync(nextPageLink, poolListNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
